/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.validator.impl;

import com.hikvision.swdf.util.validator.impl.AbstractValidator;
import com.ivms6.core.util.StringUtils;
import java.io.UnsupportedEncodingException;

public class DefaultValidator
extends AbstractValidator {
    private static final String ENCODING = "UTF-8";
    private static final int CHINESE_UNIT_LENGTH = 3;
    private static final String REG_CHARSET = "[\u4e00-\u9fa5]";
    private boolean required = false;
    private Integer minLength;
    private Integer maxLength;
    private boolean hasChinese = false;
    private int chineseUnitLength = 3;

    public boolean validateRequired(String val) {
        if (this.required && StringUtils.isBlank((String)val)) {
            this.messageKey = "validator.required";
            return false;
        }
        return true;
    }

    public boolean validateLength(String val) {
        if (this.minLength != null || this.maxLength != null) {
            String messageKey;
            int length = 0;
            if (val == null) {
                length = 0;
            } else if (this.hasChinese) {
                if (this.chineseUnitLength == 3) {
                    try {
                        length = val.getBytes(ENCODING).length;
                    }
                    catch (UnsupportedEncodingException e) {
                        length = val.replaceAll(REG_CHARSET, "***").length();
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < this.chineseUnitLength; ++i) {
                        sb.append("*");
                    }
                    length = val.replaceAll(REG_CHARSET, sb.toString()).length();
                }
            } else {
                length = val.length();
            }
            if (this.minLength != null && this.maxLength != null && this.minLength.equals(this.maxLength)) {
                if (this.minLength != length) {
                    messageKey = "validator.fixLength";
                    if (this.hasChinese) {
                        messageKey = messageKey + ".chinese";
                    }
                    this.setMessageKey(messageKey, false);
                    return false;
                }
                return true;
            }
            if (this.minLength != null && length < this.minLength) {
                if (this.maxLength != null && length > this.maxLength) {
                    messageKey = "validator.minLength.maxLength";
                    if (this.hasChinese) {
                        messageKey = messageKey + ".chinese";
                    }
                    return false;
                }
                messageKey = "validator.minLength";
                if (this.hasChinese) {
                    messageKey = messageKey + ".chinese";
                }
                return false;
            }
            if (this.maxLength != null && length > this.maxLength) {
                messageKey = "validator.maxLength";
                if (this.hasChinese) {
                    messageKey = messageKey + ".chinese";
                }
                this.setMessageKey(messageKey, false);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean validate(Object result) {
        if (result instanceof String) {
            String val = (String)result;
            if (!this.validateRequired(val)) {
                return false;
            }
            if (!this.validateLength(val)) {
                return false;
            }
        } else if (this.required && result == null) {
            this.setMessageKey("validator.required", false);
            return false;
        }
        return true;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getHasChinese() {
        return this.hasChinese;
    }

    public void setHasChinese(Boolean hasChinese) {
        this.hasChinese = hasChinese;
    }

    public int getChineseUnitLength() {
        return this.chineseUnitLength;
    }

    public void setChineseUnitLength(int chineseUnitLength) {
        this.chineseUnitLength = chineseUnitLength;
    }
}

