/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.validator.impl;

import com.hikvision.swdf.util.validator.impl.AbstractValidator;
import com.ivms6.core.util.StringUtils;

public class IpValidator
extends AbstractValidator {
    public boolean isIpWildcard = true;

    @Override
    public boolean validate(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return true;
        }
        if (StringUtils.isBlank((String)((String)value))) {
            return true;
        }
        String str = ((String)value).trim();
        this.setMessageKey("validator.ip", false);
        String[] ips = null;
        if (str.indexOf(46) <= 0) {
            return false;
        }
        ips = StringUtils.split((String)str, (String)".");
        if (ips.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            String ipp = ips[i];
            if (StringUtils.isBlank((String)ipp)) {
                return false;
            }
            if (!StringUtils.isNumeric((String)ipp)) {
                return false;
            }
            int ipValue = Integer.parseInt(ipp, 10);
            if (ipValue < 0 || ipValue > 255) {
                return false;
            }
            if (this.isIpWildcard || ipValue != 0) continue;
            return false;
        }
        return true;
    }

    public void setIsIpWildcard(boolean isIpWildcard) {
        this.isIpWildcard = isIpWildcard;
    }
}

