/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.validator.impl;

import com.hikvision.swdf.util.validator.impl.AbstractValidator;
import com.ivms6.core.util.StringUtils;

public class NumberValidator
extends AbstractValidator {
    Boolean allowDecimals = false;
    Boolean allowNegative = false;
    Double minValue = null;
    Double maxValue = null;

    @Override
    public boolean validate(Object object) {
        if (object == null) {
            return true;
        }
        String val = (String)object;
        if (StringUtils.isBlank((String)val)) {
            return true;
        }
        Double value = this.parseDouble(val);
        if (value == null) {
            this.setMessageKey("validate.number", false);
            return false;
        }
        if (!this.allowDecimals.booleanValue() && StringUtils.indexOf((String)val, (String)".") > -1) {
            this.setMessageKey("validate.noAllowDecimals", false);
            return false;
        }
        if (!this.allowNegative.booleanValue() && value < 0.0) {
            this.setMessageKey("validate.noAllowNegative", false);
            return false;
        }
        if (this.minValue != null && value < this.minValue) {
            this.setMessageKey("validate.minValue", false);
            return false;
        }
        if (this.maxValue != null && value > this.maxValue) {
            this.setMessageKey("validate.maxValue", false);
            return false;
        }
        return true;
    }

    private Double parseDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Boolean getAllowDecimals() {
        return this.allowDecimals;
    }

    public void setAllowDecimals(Boolean allowDecimals) {
        this.allowDecimals = allowDecimals;
    }

    public Boolean getAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(Boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public Number getMinValueNumber() {
        if (!this.allowDecimals.booleanValue()) {
            return this.minValue == null ? null : Integer.valueOf(this.minValue.intValue());
        }
        return this.minValue;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public Number getMaxValueNumber() {
        if (!this.allowDecimals.booleanValue()) {
            return this.maxValue == null ? null : Integer.valueOf(this.maxValue.intValue());
        }
        return this.maxValue;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }
}

