/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.www.filter.url;

import com.hikvision.swdf.util.match.PatternMatcher;
import com.hikvision.swdf.www.filter.url.IURLFilter;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.Map;
import java.util.Set;

public class BasicURLFilter
implements IURLFilter {
    protected String SECTION_URL_AUTH = "url-auth";
    protected String AUTH_URL = "withoutauth";
    protected String SESSION_URL = "withoutlogin";
    protected String SECTION_GLOBAL_RESULT = "global-result";
    protected String KEY_GLOBAL_RESULT_PREFIX = "global.result.";
    protected String KEY_GLOBAL_RESULT_DEFAULT = "/error.jsp";
    private PatternMatcher hikMatcher;

    public PatternMatcher getHikMatcher() {
        return this.hikMatcher;
    }

    public void setHikMatcher(PatternMatcher hikMatcher) {
        this.hikMatcher = hikMatcher;
    }

    @Override
    public boolean canAccess(String url, String userId) {
        if (this.validateUrl(url, this.AUTH_URL)) {
            return true;
        }
        return true;
    }

    @Override
    public boolean isIgnoreURL(String url) {
        return this.validateUrl(url, this.SESSION_URL);
    }

    protected boolean validateUrl(String url, String auth) {
        Map section = ConfigManager.getSection((String)this.SECTION_URL_AUTH);
        if (section == null) {
            return true;
        }
        Set entryList = section.entrySet();
        for (Map.Entry entry : entryList) {
            if (StringUtils.isEmpty((String)((String)entry.getValue())) || !((String)entry.getValue()).contains(auth) || !this.hikMatcher.matches((String)entry.getKey(), url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getResultURL(String resultName) {
        String globalReault = this.KEY_GLOBAL_RESULT_PREFIX + "default";
        Map section = ConfigManager.getSection((String)this.SECTION_GLOBAL_RESULT);
        if (section == null) {
            return this.KEY_GLOBAL_RESULT_DEFAULT;
        }
        String result = (String)section.get("global.result." + resultName);
        if (StringUtils.isEmpty((String)result)) {
            return (String)section.get(globalReault);
        }
        return result;
    }
}

