/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core;

import com.hikvision.cms.cache.core.CacheCluster;
import com.hikvision.cms.cache.core.tools.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCacheCluster
implements CacheCluster {
    public static final String CACHE_NAME = "name";
    public static final String CACHE_DEPLOY = "deploy";
    protected List<String> deploys;
    protected Map<String, String> deployMaps;
    protected String cacheName;
    private String prefix;

    protected String getKey(String type) {
        return this.prefix + "." + type;
    }

    protected String getValue(Properties properties, String type) {
        return StringUtil.trimToNull((String)properties.getProperty(this.getKey(type)));
    }

    public AbstractCacheCluster(Properties properties, String prefix) {
        this.prefix = prefix;
        this.cacheName = this.getValue(properties, CACHE_NAME);
        String deploysValue = this.getValue(properties, CACHE_DEPLOY);
        if (deploysValue == null) {
            return;
        }
        String[] deploysSplit = StringUtils.split((String)deploysValue, (String)",");
        this.deploys = new ArrayList<String>();
        this.deployMaps = new HashMap<String, String>();
        for (String deploy : deploysSplit) {
            String deployTemp = (String)properties.get("cache.deploy." + deploy);
            if (StringUtil.isEmpty((String)deployTemp)) {
                return;
            }
            this.deploys.add(deploy);
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public List<String> getDeploys() {
        return this.deploys;
    }
}

