/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core;

import com.hikvision.cms.cache.core.AbstractCacheCluster;
import com.hikvision.cms.cache.core.coherence.cluster.PropertiesCoherenceCluster;
import com.hikvision.cms.cache.core.exception.DefinitionException;
import com.hikvision.cms.cache.core.memcached.cluster.PropertiesMemcachedCluster;
import com.hikvision.cms.cache.core.redis.cluster.PropertiesRedisCluster;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheCluster {
    public static final Logger log = LoggerFactory.getLogger(CacheCluster.class);
    public static final String CACHE_CLUSTER = "cache.cluster";
    public static final String POINT = ".";
    public static final String SPLIT = ",";
    public static final String CACHE_TYPE = "type";
    public static final String DEPLOY_PREFIX = "cache.deploy.";
    public static final String CacheCluster_MEMCACHED = "memcached";
    public static final String CacheCluster_COHERENCE = "coherence";
    public static final String CacheCluster_REDIS = "redis";

    public String getCacheName();

    public List<String> getDeploys();

    public static class Builder {
        public static CacheCluster build(Properties properties, String aname) {
            AbstractCacheCluster cacheCluster;
            String prefix = "cache.cluster." + aname.trim();
            String typeKey = prefix + CacheCluster.POINT + CacheCluster.CACHE_TYPE;
            String type = StringUtils.trimToEmpty((String)((String)properties.get(typeKey)));
            if (CacheCluster.CacheCluster_COHERENCE.equals(type.toLowerCase(Locale.ENGLISH))) {
                cacheCluster = new PropertiesCoherenceCluster(properties, prefix);
            } else if (CacheCluster.CacheCluster_MEMCACHED.equals(type.toLowerCase(Locale.ENGLISH))) {
                cacheCluster = new PropertiesMemcachedCluster(properties, prefix);
            } else if (CacheCluster.CacheCluster_REDIS.equals(type.toLowerCase(Locale.ENGLISH))) {
                cacheCluster = new PropertiesRedisCluster(properties, prefix);
            } else {
                throw new DefinitionException("\u96c6\u7fa4\u7c7b\u578b(type)\u9519\u8bef");
            }
            if (log.isDebugEnabled()) {
                log.debug(prefix + ",\u8be5\u96c6\u7fa4\u89e3\u6790\u5b8c\u6210,\u96c6\u7fa4\u7c7b\u578b\u4e3a:" + type);
            }
            return cacheCluster;
        }
    }
}

