/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core;

import com.hikvision.cms.cache.core.CacheCluster;
import com.hikvision.cms.cache.core.IHikCache;
import com.hikvision.cms.cache.core.cacheclient.MemcachedClient;
import com.hikvision.cms.cache.core.cacheclient.RedisClient;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.exception.DefinitionException;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.redis.cluster.RedisCluster;
import com.hikvision.cms.cache.core.tools.StringUtil;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConnect {
    protected static final Logger log = LoggerFactory.getLogger(CacheConnect.class);
    public static final String DEFAULT_DEPLOY = "default";
    public static final String PRE_DEPLOY = "cache.deploy.";
    public static final String SUF_CLUSTER = ".cluster";
    private ConcurrentMap<String, IHikCache> deployCacheClientMap = new ConcurrentHashMap<String, IHikCache>();
    String defaultDeploy;
    List<CacheCluster> cacheClusterList;
    Map<String, String> deployMap;
    Map<String, CacheCluster> deployCacheClusterMap;

    public IHikCache getCacheClient() throws CacheConnectException {
        return this.getCacheClient(this.defaultDeploy);
    }

    public IHikCache getCacheClient(String deploy) throws CacheConnectException {
        if (this.deployCacheClientMap.get(deploy) == null) {
            CacheCluster cluster = this.deployCacheClusterMap.get(deploy);
            if (cluster == null) {
                return null;
            }
            if (cluster instanceof MemcachedCluster) {
                this.deployCacheClientMap.put(deploy, new MemcachedClient((MemcachedCluster)cluster));
            } else if (cluster instanceof RedisCluster) {
                this.deployCacheClientMap.put(deploy, new RedisClient((RedisCluster)cluster));
            }
        }
        return (IHikCache)this.deployCacheClientMap.get(deploy);
    }

    public Map<String, String> getDeployMap() {
        return this.deployMap;
    }

    public Map<String, CacheCluster> getDeployCacheClusterMap() {
        return this.deployCacheClusterMap;
    }

    public List<CacheCluster> getCacheClusterList() {
        return this.cacheClusterList;
    }

    public String getDefaultDeployId() {
        return this.defaultDeploy;
    }

    public static class Builder {
        private static final String DEFAULT_CONFIG_PATH = "classpath:cache-connect.properties";

        public static CacheConnect build() throws DefinitionException {
            Map map = null;
            try {
                map = ConfigManager.getSection((String)"cache-connect");
            }
            catch (Exception e) {
                log.debug("no 'system.properties' file ->next read 'cache-connect.properties'");
            }
            if (CollectionUtils.isEmpty((Map)map)) {
                return Builder.build(DEFAULT_CONFIG_PATH);
            }
            return Builder.build("classpath:system.properties");
        }

        public static CacheConnect build(String path) throws DefinitionException {
            Properties properties = Builder.getProperties(path);
            return Builder.build(properties);
        }

        public static CacheCluster buildCluster(Properties properties, String cacheClusterName) throws DefinitionException {
            if (StringUtils.isBlank((String)cacheClusterName)) {
                throw new DefinitionException("\u96c6\u7fa4(" + cacheClusterName + "):\u4e0d\u5b58\u5728!");
            }
            CacheCluster cacheClusterInfo = CacheCluster.Builder.build(properties, StringUtils.trim((String)cacheClusterName));
            return cacheClusterInfo;
        }

        public static CacheConnect build(Properties properties) throws DefinitionException {
            if (properties == null) {
                throw new DefinitionException("properties \u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8bfb\u53d6\u9519\u8bef!");
            }
            String defaultDeploy = CacheConnect.DEFAULT_DEPLOY;
            Set<Object> keySet = properties.keySet();
            if (keySet == null || keySet.isEmpty()) {
                throw new DefinitionException("properties \u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            HashMap<String, String> deployMap = new HashMap<String, String>();
            HashMap<String, CacheCluster> deployCacheClusterMap = new HashMap<String, CacheCluster>();
            Iterator<Object> keyIt = keySet.iterator();
            int preDeployLength = CacheConnect.PRE_DEPLOY.length();
            while (keyIt.hasNext()) {
                String tempKeyEnd;
                String tempKey = (String)keyIt.next();
                if (tempKey.indexOf(CacheConnect.PRE_DEPLOY) != 0 || (tempKeyEnd = tempKey.substring(preDeployLength)).indexOf(".") > -1 || tempKeyEnd.length() < 1) continue;
                String cacheClusterName = (String)properties.get(tempKey + CacheConnect.SUF_CLUSTER);
                deployMap.put(tempKeyEnd, (String)properties.get(tempKey));
                deployCacheClusterMap.put(tempKeyEnd, Builder.buildCluster(properties, cacheClusterName));
            }
            if (deployMap.get(defaultDeploy) == null) {
                throw new DefinitionException("default:\u914d\u7f6e\u9519\u8bef!");
            }
            CacheConnect connect = new CacheConnect();
            connect.defaultDeploy = defaultDeploy;
            connect.deployCacheClusterMap = deployCacheClusterMap;
            connect.deployMap = deployMap;
            return connect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Properties getProperties(String path) {
            Properties properties = new Properties();
            InputStream input = null;
            try {
                if (StringUtil.isBlank((String)path)) {
                    path = DEFAULT_CONFIG_PATH;
                }
                input = path.indexOf("classpath:") == 0 ? CacheConnect.class.getClassLoader().getResourceAsStream(path.substring("classpath:".length())) : (path.indexOf("file:") == 0 ? new FileInputStream(URLDecoder.decode(path.substring("file:".length()), "utf-8")) : new FileInputStream(URLDecoder.decode(path, "utf-8")));
                properties.load(input);
            }
            catch (FileNotFoundException e) {
                log.error(".properties\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            catch (IOException e) {
                log.error(".properties\u6587\u4ef6\u83b7\u53d6IO\u5f02\u5e38");
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        log.error(".properties\u6587\u4ef6\u5173\u95edIO\u5f02\u5e38");
                    }
                }
            }
            return properties;
        }
    }
}

