/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core;

import com.hikvision.cms.cache.core.CacheCluster;
import com.hikvision.cms.cache.core.CacheConnect;
import com.hikvision.cms.cache.core.IHikCache;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.tools.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConnectFactory {
    protected static final Logger log = LoggerFactory.getLogger(CacheConnectFactory.class);
    private static CacheConnect cacheConnect;
    private static String configFile;

    private static synchronized void createClient() {
        if (cacheConnect == null) {
            cacheConnect = StringUtils.isNotBlank((String)configFile) ? CacheConnect.Builder.build(configFile) : CacheConnect.Builder.build();
        }
    }

    public static IHikCache getCache() throws CacheConnectException {
        return CacheConnectFactory.getCache(null);
    }

    public static IHikCache getCache(String deployId) throws CacheConnectException {
        if (cacheConnect == null) {
            CacheConnectFactory.createClient();
        }
        if (StringUtil.isBlank((String)deployId)) {
            deployId = CacheConnectFactory.getDefaultDeployId();
        }
        return cacheConnect.getCacheClient(deployId);
    }

    public static String getDefaultDeployId() {
        if (cacheConnect == null) {
            CacheConnectFactory.createClient();
        }
        return cacheConnect.getDefaultDeployId();
    }

    public static String getDeployName() {
        return cacheConnect.getDeployMap().get(CacheConnectFactory.getDefaultDeployId());
    }

    public static String getDeployName(String deployId) {
        if (StringUtil.isBlank((String)deployId)) {
            deployId = CacheConnectFactory.getDefaultDeployId();
        }
        return cacheConnect.getDeployMap().get(deployId);
    }

    public static CacheCluster getCacheCluster(String deployId) {
        if (cacheConnect == null) {
            CacheConnectFactory.createClient();
        }
        if (StringUtil.isBlank((String)deployId)) {
            deployId = CacheConnectFactory.getDefaultDeployId();
        }
        return cacheConnect.getDeployCacheClusterMap().get(deployId);
    }
}

