/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.cacheclient;

import com.google.code.yanf4j.core.impl.StandardSocketOption;
import com.hikvision.cms.cache.core.cacheclient.AbstractCacheClient;
import com.hikvision.cms.cache.core.cacheclient.cas.ListProcessor;
import com.hikvision.cms.cache.core.cacheclient.cas.process.CommonCasOperation;
import com.hikvision.cms.cache.core.cacheclient.cas.process.ICASProcessor;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.exception.CacheBuildException;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.exception.DefinitionException;
import com.hikvision.cms.cache.core.memcached.HikMemcachedSessionLocateBuilder;
import com.hikvision.cms.cache.core.memcached.NodeHealthManager;
import com.hikvision.cms.cache.core.memcached.cluster.CacheServer;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.tools.KeyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.CASOperation;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedClient
extends AbstractCacheClient {
    private Integer serverCount = 0;
    private net.rubyeye.xmemcached.MemcachedClient cache = null;
    public static final Logger log = LoggerFactory.getLogger(MemcachedClient.class);
    private Object syncObj = new Object();
    private MemcachedCluster cacheCluster;
    private volatile boolean isConnecting = false;
    private int defaultCasKeyHash = 5;
    public static final String SPLIT = "#";
    protected HashAlgorithm hashAlgorighm = HashAlgorithm.NATIVE_HASH;

    public MemcachedClient(MemcachedCluster cacheCluster) throws CacheConnectException {
        try {
            this.cacheCluster = cacheCluster;
            List<CacheServer> serverList = cacheCluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.OTHER);
            if (serverList != null && serverList.size() > 0) {
                this.serverCount = serverList.size();
            }
            this.cache = Builder.build(cacheCluster);
        }
        catch (CacheBuildException e) {
            log.error("cache client builder error:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private net.rubyeye.xmemcached.MemcachedClient getCache() throws DefinitionException, IOException, CacheConnectException {
        if (this.cache == null && !this.isConnecting) {
            Object object = this.syncObj;
            synchronized (object) {
                if (this.cache == null) {
                    this.isConnecting = true;
                    try {
                        this.cache = Builder.build(this.cacheCluster);
                    }
                    catch (CacheBuildException e) {
                        log.error("cache client builder error:", (Throwable)e);
                        throw new CacheConnectException(e);
                    }
                    finally {
                        this.isConnecting = false;
                    }
                }
            }
        }
        if (this.cache == null) {
            throw new CacheConnectException("cache server is not connected.");
        }
        return this.cache;
    }

    private void shutdownClient() {
        log.info("==============shutdownClient has do nothing================");
    }

    @Override
    public Object get(String key) throws CacheConnectException {
        boolean mainNodeOpt = false;
        try {
            Object value = this.getCache().get(key);
            mainNodeOpt = true;
            if (value == null && this.isStandBy(key)) {
                value = this.getCache().get(this.standByKey(key));
            }
            log.debug(this.genLog("Get", key, value));
            return value;
        }
        catch (MemcachedException e) {
            if (mainNodeOpt) {
                return null;
            }
            if (!mainNodeOpt && this.isStandBy(key)) {
                log.error("cache get from main node MemcachedException:" + key, (Throwable)e);
                return this.getStandBy(this.standByKey(key));
            }
            throw new CacheConnectException((Exception)((Object)e));
        }
        catch (DefinitionException e) {
            log.error("cache get DefinitionException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            if (mainNodeOpt) {
                return null;
            }
            if (!mainNodeOpt && this.isStandBy(key)) {
                return this.getStandBy(this.standByKey(key));
            }
            log.error("cache get TimeoutException:" + key, (Throwable)e);
            this.shutdownClient();
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("cache get InterruptedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (IOException e) {
            log.error("cache get IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
    }

    private boolean isStandBy(String key) {
        return KeyUtil.isSession(key) && this.serverCount > 1;
    }

    private Object getStandBy(String key) throws CacheConnectException {
        try {
            Object value = this.getCache().get(key);
            log.debug(this.genLog("Get", key, value));
            return value;
        }
        catch (DefinitionException e) {
            log.error("get stand by DefinitionException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            log.error("get stand by TimeoutException:" + key, (Throwable)e);
            this.shutdownClient();
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("get stand by InterruptedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (MemcachedException e) {
            log.error("get stand by MemcachedException:" + key, (Throwable)e);
            throw new CacheConnectException((Exception)((Object)e));
        }
        catch (IOException e) {
            log.error("get stand by IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
    }

    private String standByKey(String key) {
        return key + "_&SB";
    }

    public int getCasKeyHash(String key) {
        return this.defaultCasKeyHash;
    }

    @Override
    public boolean set(String key, Object value) throws CacheConnectException {
        return this.set(key, value, 0L);
    }

    @Override
    public boolean set(String key, Object value, long expiry) throws CacheConnectException {
        boolean mainNodeOpt = false;
        boolean optResult = false;
        try {
            optResult = this.getCache().set(key, this.ms2second(expiry), value);
            mainNodeOpt = true;
            if (this.isStandBy(key)) {
                this.getCache().set(this.standByKey(key), this.ms2second(expiry), value);
            }
            log.debug(this.genLog("Set", key, value));
            return true;
        }
        catch (MemcachedException e) {
            log.error("cache set MemcachedException:" + key, (Throwable)e);
            if (!mainNodeOpt) {
                if (this.isStandBy(key)) {
                    return this.setStandBy(this.standByKey(key), value, expiry);
                }
                throw new CacheConnectException((Exception)((Object)e));
            }
        }
        catch (DefinitionException e) {
            log.error("cache set DefinitionException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            log.error("cache set TimeoutException:" + key, (Throwable)e);
            if (!mainNodeOpt) {
                if (this.isStandBy(key)) {
                    return this.setStandBy(this.standByKey(key), value, expiry);
                }
                this.shutdownClient();
                throw new CacheConnectException(e);
            }
        }
        catch (InterruptedException e) {
            log.error("cache set InterruptedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (IOException e) {
            log.error("cache set IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        return optResult;
    }

    private int ms2second(long expiry) {
        return (int)(expiry % 1000L > 0L ? expiry / 1000L + 1L : expiry / 1000L);
    }

    private boolean setStandBy(String key, Object value, long expiry) throws CacheConnectException {
        try {
            boolean result = this.getCache().set(key, this.ms2second(expiry), value);
            log.debug(this.genLog("Set", key, value));
            return result;
        }
        catch (DefinitionException e) {
            log.error("cache set stand by DefinitionException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            log.error("cache set stand by TimeoutException:" + key, (Throwable)e);
            this.shutdownClient();
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("cache set stand by InterruptedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (MemcachedException e) {
            log.error("cache set stand by MemcachedException:" + key, (Throwable)e);
            throw new CacheConnectException((Exception)((Object)e));
        }
        catch (IOException e) {
            log.error("cache set stand by IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
    }

    @Override
    public boolean remove(String key) throws CacheConnectException {
        boolean mainNodeOpt = false;
        boolean optResult = false;
        try {
            optResult = this.getCache().delete(key);
            mainNodeOpt = true;
            if (this.isStandBy(key)) {
                this.getCache().delete(this.standByKey(key));
            }
            log.debug(this.genLog("Remove", key, null));
        }
        catch (IOException e) {
            log.error("cache remove IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (DefinitionException e) {
            log.error("cache remove DefinitionException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            if (!mainNodeOpt && this.isStandBy(key)) {
                this.removeStandBy(this.standByKey(key));
            }
            log.error("cache remove TimeoutException:" + key, (Throwable)e);
            this.shutdownClient();
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("cache remove InterruptedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (MemcachedException e) {
            if (!mainNodeOpt && this.isStandBy(key)) {
                this.removeStandBy(this.standByKey(key));
            }
            log.error("cache remove MemcachedException:" + key, (Throwable)e);
            throw new CacheConnectException((Exception)((Object)e));
        }
        return optResult;
    }

    private void removeStandBy(String key) throws CacheConnectException {
        try {
            this.getCache().delete(key);
            log.debug(this.genLog("Remove", key, null));
        }
        catch (IOException e) {
            log.error("cache remove stand by IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (DefinitionException e) {
            log.error("cache remove stand by DefinitionException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            this.shutdownClient();
            log.error("cache remove stand by TimeoutException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("cache remove stand by InterruptedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (MemcachedException e) {
            log.error("cache remove stand by MemcachedException:" + key, (Throwable)e);
            throw new CacheConnectException((Exception)((Object)e));
        }
    }

    @Override
    public void clear() throws CacheConnectException {
        try {
            this.getCache().flushAll();
            log.debug(this.genLog("clear", "all", null));
        }
        catch (IOException e) {
            log.error("cache clear IOException:", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (DefinitionException e) {
            log.error("cache clear DefinitionException:", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            this.shutdownClient();
            log.error("cache clear TimeoutException:", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("cache clear InterruptedException:", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (MemcachedException e) {
            log.error("cache clear MemcachedException:", (Throwable)e);
            throw new CacheConnectException((Exception)((Object)e));
        }
    }

    public long getHash(String value) {
        return this.hashAlgorighm.hash(value);
    }

    @Override
    public Object cas(String key, int times, ICASProcessor processor) throws CacheConnectException {
        try {
            this.getCache().add(key, 0, (Object)"");
            CommonCasOperation casOperation = new CommonCasOperation();
            casOperation.setProcessor(processor);
            this.getCache().cas(key, (CASOperation)casOperation);
            Object result = casOperation.getResult();
            log.debug(this.genLog("cas", key, result));
            return result;
        }
        catch (IOException e) {
            log.error("cache cas IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (DefinitionException e) {
            log.error("cache cas DefinitionException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            this.shutdownClient();
            log.error("cache cas TimeoutException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("cache cas InterruptedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (MemcachedException e) {
            log.error("cache cas MemcachedException:" + key, (Throwable)e);
            throw new CacheConnectException((Exception)((Object)e));
        }
    }

    @Override
    public Object cas(String key, ICASProcessor operation) throws CacheConnectException {
        return this.cas(key, 30, operation);
    }

    @Override
    public Map<String, Object> get(List<String> keyList) throws CacheConnectException {
        try {
            Map map = this.getCache().get(keyList);
            return map;
        }
        catch (IOException e) {
            log.error("cache get by keyList IOException", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (DefinitionException e) {
            log.error("cache get by keyList DefinitionException", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (TimeoutException e) {
            this.shutdownClient();
            log.error("cache get by keyList TimeoutException", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (InterruptedException e) {
            log.error("cache get by keyList InterruptedException", (Throwable)e);
            throw new CacheConnectException(e);
        }
        catch (MemcachedException e) {
            log.error("cache get by keyList MemcachedException", (Throwable)e);
            throw new CacheConnectException((Exception)((Object)e));
        }
    }

    @Override
    public String[] getList(String key) throws CacheConnectException {
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < this.getCasKeyHash(key); ++i) {
            keys.add(key + SPLIT + i + "_&LE");
        }
        StringBuffer result = new StringBuffer();
        Map<String, Object> resultMap = this.get(keys);
        if (resultMap != null && resultMap.values() != null) {
            for (Object o : resultMap.values()) {
                if (o == null) continue;
                result.append(o);
            }
        }
        return ListProcessor.valuesToArray(result.toString());
    }

    @Override
    public boolean addToList(String key, String value) throws CacheConnectException {
        ListProcessor processor = new ListProcessor(ListProcessor.OPERATOR_TYPE.INCREASE, value);
        this.cas(key + SPLIT + this.getHash(value) % (long)this.getCasKeyHash(key) + "_&LE", processor);
        return true;
    }

    @Override
    public boolean removeFromList(String key, String value) throws CacheConnectException {
        this.cas(key + SPLIT + this.getHash(value) % (long)this.getCasKeyHash(key) + "_&LE", new ListProcessor(ListProcessor.OPERATOR_TYPE.REDUCTION, value));
        return true;
    }

    public static class Builder {
        public static net.rubyeye.xmemcached.MemcachedClient build(MemcachedCluster cluster) throws CacheBuildException {
            try {
                net.rubyeye.xmemcached.MemcachedClient memcachedClient;
                NodeHealthManager nodeHealthManager = new NodeHealthManager();
                cluster.setHealthManager(nodeHealthManager);
                Object[] servers = cluster.getServers();
                Object[] backupServers = cluster.getBackupServers();
                Map serverAddressMap = AddrUtil.getAddressMap((String)StringUtils.join((Object[])servers, (String)" "));
                if (backupServers != null && backupServers.length < 1) {
                    serverAddressMap.putAll(AddrUtil.getAddressMap((String)StringUtils.join((Object[])backupServers, (String)" ")));
                }
                XMemcachedClientBuilder builder = new XMemcachedClientBuilder(serverAddressMap);
                builder.setSessionLocator(HikMemcachedSessionLocateBuilder.build(cluster));
                builder.setConnectionPoolSize(cluster.getConnectionPoolSize());
                if (StringUtils.isNotBlank((String)cluster.getCacheName())) {
                    builder.setName(cluster.getCacheName());
                }
                if (cluster.getConnectionPoolSize() > 0) {
                    builder.setConnectionPoolSize(cluster.getConnectionPoolSize());
                }
                if (cluster.getConnectTimeout() > 0L) {
                    builder.setConnectTimeout(cluster.getConnectTimeout());
                }
                if (cluster.getReceiveBuf() > 0) {
                    builder.setSocketOption(StandardSocketOption.SO_RCVBUF, (Object)(cluster.getReceiveBuf() * 1024));
                }
                if (cluster.getSendBuf() > 0) {
                    builder.setSocketOption(StandardSocketOption.SO_SNDBUF, (Object)(cluster.getSendBuf() * 1024));
                }
                if (cluster.getTcpNodelay() != null) {
                    builder.setSocketOption(StandardSocketOption.TCP_NODELAY, (Object)cluster.getTcpNodelay());
                }
                if (cluster.getSessionIdleTimeout() > 0L) {
                    builder.getConfiguration().setSessionIdleTimeout(10000L);
                }
                if (cluster.getEnableStats() != null) {
                    builder.getConfiguration().setStatisticsServer(cluster.getEnableStats().booleanValue());
                }
                if ((memcachedClient = builder.build()).getConnector() == null) {
                    memcachedClient.shutdown();
                    memcachedClient = null;
                }
                if (memcachedClient == null) {
                    throw new CacheBuildException("MemcachedClient init error.connect to server failed");
                }
                Set sessionset = memcachedClient.getConnector().getSessionSet();
                if (sessionset == null || sessionset.size() == 0) {
                    memcachedClient.shutdown();
                    memcachedClient = null;
                }
                if (memcachedClient == null) {
                    throw new CacheBuildException("MemcachedClient init error.connect to server failed");
                }
                if (cluster.getMergeFactor() > 0) {
                    memcachedClient.setMergeFactor(cluster.getMergeFactor());
                }
                if (cluster.getOptimizeMergeBuffer() != null) {
                    memcachedClient.setOptimizeMergeBuffer(cluster.getOptimizeMergeBuffer().booleanValue());
                }
                if (cluster.getOptTimeout() > 0L) {
                    memcachedClient.setOpTimeout(cluster.getOptTimeout());
                }
                memcachedClient.setEnableHeartBeat(false);
                memcachedClient.setTimeoutExceptionThreshold(1);
                return memcachedClient;
            }
            catch (IOException e) {
                log.error("cache client builder error:", (Throwable)e);
                throw new CacheBuildException(e);
            }
        }
    }
}

