/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.cacheclient;

import com.hikvision.cms.cache.core.cacheclient.AbstractCacheClient;
import com.hikvision.cms.cache.core.cacheclient.cas.process.ICASProcessor;
import com.hikvision.cms.cache.core.exception.CacheBuildException;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.exception.DefinitionException;
import com.hikvision.cms.cache.core.redis.cluster.RedisCluster;
import com.hikvision.cms.cache.manager.serialize.JsonDto;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisClient
extends AbstractCacheClient {
    private JedisPool cache = null;
    public static final Logger log = LoggerFactory.getLogger(RedisClient.class);
    private RedisCluster cacheCluster;

    public RedisClient(RedisCluster cacheCluster) throws CacheConnectException {
        try {
            this.cacheCluster = cacheCluster;
            this.cache = Builder.build(cacheCluster);
        }
        catch (CacheBuildException e) {
            log.error("cache client builder error:", (Throwable)e);
        }
    }

    private Jedis getCache() throws DefinitionException, IOException, CacheConnectException {
        return this.cache.getResource();
    }

    private void returnJedis(Jedis jedis) {
        if (jedis != null) {
            this.cache.returnResource(jedis);
        }
    }

    private void returnBrokenJedis(Jedis jedis) {
        this.cache.returnBrokenResource(jedis);
    }

    @Override
    public Object get(String key) throws CacheConnectException {
        Jedis jedis = null;
        try {
            String value;
            jedis = this.getCache();
            String string = value = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            log.error("cache get IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public boolean set(String key, Object value) throws CacheConnectException {
        Jedis jedis = null;
        try {
            jedis = this.getCache();
            if (value instanceof CharSequence) {
                jedis.set(key, value.toString());
            } else {
                JsonDto dto = new JsonDto(value);
                jedis.set(key, dto.getJson());
            }
            boolean dto = true;
            return dto;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            log.error("cache set IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public boolean set(String key, Object value, long expiry) throws CacheConnectException {
        Jedis jedis = null;
        try {
            jedis = this.getCache();
            if (value instanceof CharSequence) {
                jedis.setex(key, this.ms2second(expiry), value.toString());
            } else {
                JsonDto dto = new JsonDto(value);
                jedis.setex(key, this.ms2second(expiry), dto.getJson());
            }
            boolean dto = true;
            return dto;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            log.error("cache set IOException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    private int ms2second(long expiry) {
        return (int)(expiry % 1000L > 0L ? expiry / 1000L + 1L : expiry / 1000L);
    }

    @Override
    public boolean remove(String key) throws CacheConnectException {
        Jedis jedis = null;
        try {
            jedis = this.getCache();
            jedis.del(key);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            log.error("cache remove MemcachedException:" + key, (Throwable)e);
            throw new CacheConnectException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public void clear() throws CacheConnectException {
        Jedis jedis = null;
        try {
            jedis = this.getCache();
            jedis.flushAll();
            log.debug(this.genLog("clear", "all", null));
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            log.error("cache clear MemcachedException:", (Throwable)e);
            throw new CacheConnectException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Object cas(String key, int times, ICASProcessor processor) throws CacheConnectException {
        return null;
    }

    @Override
    public Object cas(String key, ICASProcessor operation) throws CacheConnectException {
        return this.cas(key, 30, operation);
    }

    @Override
    public Map<String, Object> get(List<String> keyList) throws CacheConnectException {
        return null;
    }

    @Override
    public String[] getList(String key) throws CacheConnectException {
        return null;
    }

    @Override
    public boolean addToList(String key, String value) throws CacheConnectException {
        return true;
    }

    @Override
    public boolean removeFromList(String key, String value) throws CacheConnectException {
        return true;
    }

    public static class Builder {
        public static JedisPool build(RedisCluster cluster) throws CacheBuildException {
            try {
                GenericObjectPoolConfig config = new GenericObjectPoolConfig();
                config.setMaxTotal(cluster.getConnectionPoolSize());
                config.setMinIdle(cluster.getConnectionMaxIdle());
                config.setMaxIdle(cluster.getConnectionMinIdle());
                JedisPool jedisPool = new JedisPool(config, cluster.getConnectionIp(), cluster.getConnectionPort(), 0, cluster.getConnectAuth());
                return jedisPool;
            }
            catch (Exception e) {
                log.error("cache client builder error:", (Throwable)e);
                throw new CacheBuildException(e);
            }
        }
    }
}

