/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.cacheclient.cas;

import com.hikvision.cms.cache.core.cacheclient.cas.process.CasEntry;
import com.hikvision.cms.cache.core.cacheclient.cas.process.ICASProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ListProcessor
implements ICASProcessor {
    private static final long serialVersionUID = 1L;
    private static final String SPLIT = ",";
    private OPERATOR_TYPE operatorType;
    private String value;
    private String values;
    private String objectValues;

    public ListProcessor(OPERATOR_TYPE operatorType, String value) {
        this.operatorType = operatorType;
        this.value = value;
    }

    @Override
    public Object process(CasEntry entry) {
        if (this.value == null) {
            return entry.getValue();
        }
        String currentValue = entry.getValue() == null ? "" : (String)entry.getValue();
        List<String> currentValueList = ListProcessor.stringToArray(currentValue);
        if (this.operatorType == OPERATOR_TYPE.INCREASE) {
            if (currentValueList.contains(this.value)) {
                return currentValue;
            }
            currentValueList.add(this.value);
            String result = ListProcessor.arrayToString(currentValueList);
            entry.setValue(result);
            return result;
        }
        if (this.operatorType == OPERATOR_TYPE.REDUCTION) {
            currentValueList.remove(this.value);
            String result = ListProcessor.arrayToString(currentValueList);
            entry.setValue(result);
            return result;
        }
        if (this.operatorType == OPERATOR_TYPE.CHECK_REDUCTION) {
            if (this.values == null || this.values.indexOf(SPLIT) < 0) {
                return "";
            }
            List<String> valuesList = ListProcessor.stringToArray(this.values);
            List<String> objectValuesList = ListProcessor.stringToArray(this.objectValues);
            StringBuffer result = new StringBuffer();
            StringBuffer newValue = new StringBuffer();
            for (String v : currentValueList) {
                if (StringUtils.isEmpty((String)v)) continue;
                if (!objectValuesList.contains(v) && valuesList.contains(v)) {
                    result.append(v);
                    result.append(SPLIT);
                    continue;
                }
                newValue.append(v);
                newValue.append(SPLIT);
            }
            entry.setValue(newValue.toString());
            return result.toString();
        }
        return currentValue;
    }

    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public String getObjectValues() {
        return this.objectValues;
    }

    public void setObjectValues(String objectValues) {
        this.objectValues = objectValues;
    }

    public OPERATOR_TYPE getOperatorType() {
        return this.operatorType;
    }

    public void setOperatorType(OPERATOR_TYPE operatorType) {
        this.operatorType = operatorType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String[] valuesToArray(String values) {
        if (values == null || values.indexOf(SPLIT) < 1) {
            return new String[0];
        }
        return values.split(SPLIT);
    }

    public static List<String> stringToArray(String values) {
        ArrayList<String> result = new ArrayList<String>();
        if (values == null || values.indexOf(SPLIT) < 1) {
            return result;
        }
        for (String value : values.split(SPLIT)) {
            result.add(value);
        }
        return result;
    }

    public static String arrayToString(List<String> list) {
        Iterator<String> it = list.iterator();
        StringBuffer result = new StringBuffer();
        while (it.hasNext()) {
            String o = it.next();
            if (o == null || o.trim().isEmpty()) continue;
            result.append(o);
            result.append(SPLIT);
        }
        return result.toString();
    }

    public static enum OPERATOR_TYPE {
        INCREASE,
        REDUCTION,
        CHECK_REDUCTION;

    }
}

