/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.impl;

import com.hikvision.cms.cache.core.CacheCluster;
import com.hikvision.cms.cache.core.CacheConnectFactory;
import com.hikvision.cms.cache.core.ICacheBase;
import com.hikvision.cms.cache.core.coherence.CoherenceCluster;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.dto.CacheBaseDto;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.exception.CacheUnSupportException;
import com.hikvision.cms.cache.core.impl.CacheBaseInfo;
import com.hikvision.cms.cache.core.impl.CacheBaseTemplate;
import com.hikvision.cms.cache.core.impl.CoherenceCacheBaseTemplate;
import com.hikvision.cms.cache.core.impl.MemcachedCacheBaseTemplate;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.tools.GenericsUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheBaseImpl<T extends CacheBaseDto, PK extends Serializable>
implements ICacheBase<T, PK> {
    public static final Logger log = LoggerFactory.getLogger(CacheBaseImpl.class);
    private CacheBaseInfo<T> cacheBaseInfo;
    private boolean isHandleKeys;
    private static final CacheBaseTemplate memcachedCacheBaseTemplate = new MemcachedCacheBaseTemplate();
    private static final CacheBaseTemplate coherenceCacheBaseTemplate = new CoherenceCacheBaseTemplate();

    public abstract CacheConstants.DATA_TYPE getDataType();

    public CacheBaseImpl() {
        this.init();
    }

    protected CacheBaseInfo<T> getCacheBaseInfo() {
        return this.cacheBaseInfo;
    }

    protected CacheBaseInfo<T> getCopyCacheBaseInfo() {
        return this.cacheBaseInfo.clone();
    }

    private void init() {
        Class entityClass = GenericsUtils.getSuperClassGenricType(this.getClass());
        this.cacheBaseInfo = new CacheBaseInfo(entityClass, this.getDataType(), this.getIsHandleKeys(), this.getDeployId());
    }

    public String getKeyPre() {
        return this.getCacheBaseTemplate().getKeyPre(this.cacheBaseInfo);
    }

    public CacheBaseImpl(boolean isHandleKeys) {
        this.isHandleKeys = isHandleKeys;
        this.init();
    }

    public String getDeployId() {
        return CacheConnectFactory.getDefaultDeployId();
    }

    protected CacheBaseTemplate getCacheBaseTemplate() {
        CacheCluster cluster = CacheConnectFactory.getCacheCluster(this.getDeployId());
        if (cluster instanceof MemcachedCluster) {
            return memcachedCacheBaseTemplate;
        }
        if (cluster instanceof CoherenceCluster) {
            return coherenceCacheBaseTemplate;
        }
        return null;
    }

    public boolean getIsHandleKeys() {
        return this.isHandleKeys;
    }

    @Override
    public T get(PK key) throws CacheConnectException {
        return this.getCacheBaseTemplate().get((Serializable)key, this.cacheBaseInfo);
    }

    @Override
    public boolean remove(PK key) throws CacheConnectException {
        return this.getCacheBaseTemplate().remove((Serializable)key, this.cacheBaseInfo);
    }

    @Override
    public void removeAll(List<PK> keys) throws CacheConnectException {
        if (keys != null) {
            for (Serializable id : keys) {
                this.remove(id);
            }
        }
    }

    @Override
    public void removeAllDto(List<T> dtos) throws CacheConnectException {
        if (dtos != null && dtos.size() > 0) {
            for (CacheBaseDto cacheBaseDto : dtos) {
                this.remove((Serializable)cacheBaseDto.getKey());
            }
        }
    }

    @Override
    public boolean save(T dto) throws CacheConnectException {
        return this.getCacheBaseTemplate().save(dto, 0L, this.cacheBaseInfo);
    }

    @Override
    public boolean save(T dto, long expiry) throws CacheConnectException {
        return this.getCacheBaseTemplate().save(dto, expiry, this.cacheBaseInfo);
    }

    @Override
    public void saveAll(List<T> list) throws CacheConnectException {
        if (list != null) {
            Iterator<T> it = list.iterator();
            while (it.hasNext()) {
                this.save((T)((CacheBaseDto)it.next()));
            }
        }
    }

    @Override
    public Map<PK, T> get(List<PK> keyList) throws CacheConnectException {
        return this.getCacheBaseTemplate().get(keyList, this.cacheBaseInfo);
    }

    @Override
    public List<String> getAllKey() throws CacheUnSupportException, CacheConnectException {
        String[] keyList = this.getCacheBaseTemplate().getKeyList(this.cacheBaseInfo);
        return keyList != null ? Arrays.asList(keyList) : null;
    }
}

