/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.impl;

import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.tools.JaxbBinder;
import com.hikvision.cms.cache.core.tools.KeyUtil;

public class CacheBaseInfo<T>
implements Cloneable {
    private JaxbBinder jaxbBinder;
    private Class<T> entityClass;
    private boolean isHandleKeys;
    private CacheConstants.DATA_TYPE dataType;
    private String deployId;

    public CacheBaseInfo(Class<T> entityClass, CacheConstants.DATA_TYPE dataType, boolean isHandleKeys, String deployId) {
        this.entityClass = entityClass;
        this.jaxbBinder = new JaxbBinder(entityClass);
        this.dataType = dataType;
        this.isHandleKeys = isHandleKeys;
        this.deployId = deployId;
    }

    public final String getKeyPre() {
        return KeyUtil.getKeyPre(this.deployId, this.dataType) + this.entityClass.getName();
    }

    public JaxbBinder getJaxbBinder() {
        return this.jaxbBinder;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean isHandleKeys() {
        return this.isHandleKeys;
    }

    public CacheConstants.DATA_TYPE getDataType() {
        return this.dataType;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public void setDeployId(String deployId) {
        this.deployId = deployId;
    }

    public void setJaxbBinder(JaxbBinder jaxbBinder) {
        this.jaxbBinder = jaxbBinder;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public void setHandleKeys(boolean isHandleKeys) {
        this.isHandleKeys = isHandleKeys;
    }

    public void setDataType(CacheConstants.DATA_TYPE dataType) {
        this.dataType = dataType;
    }

    public CacheBaseInfo<T> clone() {
        try {
            return (CacheBaseInfo)super.clone();
        }
        catch (Exception e) {
            return new CacheBaseInfo<T>(this.entityClass, this.dataType, this.isHandleKeys, this.deployId);
        }
    }
}

