/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.impl;

import com.hikvision.cms.cache.core.CacheConnectFactory;
import com.hikvision.cms.cache.core.IHikCache;
import com.hikvision.cms.cache.core.dto.CacheBaseDto;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.exception.CacheUnSupportException;
import com.hikvision.cms.cache.core.impl.CacheBaseInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheBaseTemplate {
    public static final Logger log = LoggerFactory.getLogger(CacheBaseTemplate.class);

    public final IHikCache getCache() throws CacheConnectException {
        return CacheConnectFactory.getCache();
    }

    public final <T extends CacheBaseDto> String getKeyPre(CacheBaseInfo<T> cacheBaseInfo) {
        return cacheBaseInfo.getKeyPre();
    }

    public <T extends CacheBaseDto> T get(Serializable key, CacheBaseInfo<T> cacheBaseInfo) throws CacheConnectException {
        String xml = (String)this.getCache().get(new StringBuffer(this.getKeyPre(cacheBaseInfo)).append("$").append(key).toString());
        if (StringUtils.isNotBlank((String)xml)) {
            return (T)((CacheBaseDto)cacheBaseInfo.getJaxbBinder().fromXml(xml));
        }
        return null;
    }

    public <T extends CacheBaseDto> boolean remove(Serializable key, CacheBaseInfo<T> cacheBaseInfo) throws CacheConnectException {
        String keyPre = this.getKeyPre(cacheBaseInfo);
        boolean result = this.getCache().remove(new StringBuffer(keyPre).append("$").append(key).toString());
        if (log.isDebugEnabled()) {
            log.debug("cache-core remove cache of key:" + keyPre);
        }
        return result;
    }

    public <T extends CacheBaseDto> boolean save(T dto, long expiry, CacheBaseInfo<T> cacheBaseInfo) throws CacheConnectException {
        boolean result = false;
        if (dto != null) {
            String xml = cacheBaseInfo.getJaxbBinder().toXml(dto);
            result = this.getCache().set(new StringBuffer(this.getKeyPre(cacheBaseInfo)).append("$").append(dto.getKey()).toString(), xml, expiry);
        }
        return result;
    }

    public <T extends CacheBaseDto, PK extends Serializable> Map<PK, T> get(List<PK> keyList, CacheBaseInfo<T> cacheBaseInfo) throws CacheConnectException {
        if (keyList == null) {
            return null;
        }
        if (keyList.isEmpty()) {
            return new HashMap();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Serializable pk : keyList) {
            keys.add(new StringBuffer(this.getKeyPre(cacheBaseInfo)).append("$").append(pk).toString());
        }
        Collection<Object> collection = this.getCache().get(keys).values();
        int i = 0;
        HashMap<PK, CacheBaseDto> result = new HashMap<PK, CacheBaseDto>();
        for (Object object : collection) {
            if (object != null) {
                result.put(keyList.get(i), (CacheBaseDto)cacheBaseInfo.getJaxbBinder().fromXml(object.toString()));
            }
            ++i;
        }
        return result;
    }

    public <T extends CacheBaseDto> String[] getKeyList(CacheBaseInfo<T> cacheBaseInfo) throws CacheUnSupportException, CacheConnectException {
        throw new CacheUnSupportException();
    }
}

