/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.impl;

import com.hikvision.cms.cache.core.cacheclient.cas.ListProcessor;
import com.hikvision.cms.cache.core.dto.CacheBaseDto;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.exception.CacheUnSupportException;
import com.hikvision.cms.cache.core.impl.CacheBaseInfo;
import com.hikvision.cms.cache.core.impl.CacheBaseTemplate;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedCacheBaseTemplate
extends CacheBaseTemplate {
    public static final Logger log = LoggerFactory.getLogger(MemcachedCacheBaseTemplate.class);

    @Override
    public <T extends CacheBaseDto> boolean save(T dto, long expiry, CacheBaseInfo<T> cacheBaseInfo) throws CacheConnectException {
        boolean setValue = true;
        boolean setList = true;
        if (dto != null) {
            String keyPre = this.getKeyPre(cacheBaseInfo);
            String xml = cacheBaseInfo.getJaxbBinder().toXml(dto);
            String key = dto.getKey() + "";
            setValue = this.getCache().set(new StringBuffer(keyPre).append("$").append(key).toString(), xml, expiry);
            if (cacheBaseInfo.isHandleKeys()) {
                setList = this.getCache().addToList(new StringBuffer(keyPre).append("#").append("k").toString(), key);
            }
        }
        return setValue && setList;
    }

    @Override
    public <T extends CacheBaseDto> boolean remove(Serializable key, CacheBaseInfo<T> cacheBaseInfo) throws CacheConnectException {
        boolean removeValue = true;
        boolean removeList = true;
        String keyPre = this.getKeyPre(cacheBaseInfo);
        if (cacheBaseInfo.isHandleKeys()) {
            removeList = this.getCache().removeFromList(new StringBuffer(keyPre).append("#").append("k").toString(), key.toString());
        }
        removeValue = this.getCache().remove(new StringBuffer(keyPre).append("$").append(key).toString());
        return removeList && removeValue;
    }

    @Override
    public <T extends CacheBaseDto> String[] getKeyList(CacheBaseInfo<T> cacheBaseInfo) throws CacheUnSupportException, CacheConnectException {
        if (!cacheBaseInfo.isHandleKeys()) {
            throw new CacheUnSupportException();
        }
        String values = (String)this.getCache().get(new StringBuffer(this.getKeyPre(cacheBaseInfo)).append("#").append("k").toString());
        return ListProcessor.valuesToArray(values);
    }
}

