/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached;

import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.memcached.IHealthManager;
import com.hikvision.cms.cache.core.memcached.cluster.CacheServer;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.tools.KeyUtil;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.KeyIterator;
import net.rubyeye.xmemcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFailBackTask
extends Thread {
    public static final Logger log = LoggerFactory.getLogger(NodeFailBackTask.class);
    private MemcachedCluster cluster;
    private MemcachedClient client;
    private InetSocketAddress failBackNode;
    private IHealthManager healthManager;

    public NodeFailBackTask(IHealthManager healthManager, MemcachedCluster cluster, MemcachedClient client, InetSocketAddress failBackNode) {
        this.cluster = cluster;
        this.client = client;
        this.failBackNode = failBackNode;
        this.healthManager = healthManager;
    }

    @Override
    public void run() {
        log.info("start fail back");
        InetSocketAddress backNode = this.findBackNodeAddr();
        log.info("backnode:" + backNode);
        try {
            KeyIterator it = this.client.getKeyIterator(backNode);
            HashMap<String, Object> sessionData = new HashMap<String, Object>();
            while (it.hasNext()) {
                String key = it.next();
                if (!KeyUtil.isSession(key)) continue;
                log.debug(key);
                Object value = this.client.get(key);
                key = key.replace("_&SB", "");
                sessionData.put(key, value);
            }
            this.healthManager.removeBackingNode(this.failBackNode);
            for (Map.Entry entry : sessionData.entrySet()) {
                this.client.set((String)entry.getKey(), 1200000, entry.getValue());
            }
        }
        catch (Exception e) {
            this.healthManager.removeBackingNode(this.failBackNode);
            log.error("node fail back error!", (Throwable)e);
        }
    }

    private InetSocketAddress findBackNodeAddr() {
        String addr = "";
        int port = 11211;
        CacheServer backServer = null;
        backServer = this.cluster.getBackupServerMap() != null && this.cluster.getBackupServerMap().size() > 0 ? this.cluster.getBackupServerMap().get((Object)CacheConstants.DATA_TYPE.OTHER).get(0) : this.findNextNode(this.cluster, this.failBackNode);
        if (backServer != null) {
            addr = backServer.getMajor().split(":")[0];
            port = Integer.parseInt(backServer.getMajor().split(":")[1]);
        }
        return new InetSocketAddress(addr, port);
    }

    private CacheServer findNextNode(MemcachedCluster config, InetSocketAddress failBackNode) {
        List<CacheServer> servers = this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.OTHER);
        int start = -1;
        for (int i = 0; i < servers.size(); ++i) {
            CacheServer server = servers.get(i);
            if (!server.getMajor().equals(failBackNode.getAddress().getHostAddress() + ":" + failBackNode.getPort())) continue;
            start = i;
        }
        if (start == -1) {
            return this.findNextNodeFromSessionServer(config, failBackNode);
        }
        int target = this.getNext(servers.size(), start);
        return servers.get(target);
    }

    private CacheServer findNextNodeFromSessionServer(MemcachedCluster config, InetSocketAddress failBackNode2) {
        List<CacheServer> servers = this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.SESSION);
        int start = -1;
        for (int i = 0; i < servers.size(); ++i) {
            CacheServer server = servers.get(i);
            if (!server.getMajor().equals(this.failBackNode.getAddress().getHostAddress() + ":" + this.failBackNode.getPort())) continue;
            start = i;
        }
        if (start == -1) {
            return null;
        }
        int target = this.getNext(servers.size(), start);
        return servers.get(target);
    }

    public final int getNext(int size, int start) {
        if (start == size - 1) {
            return 0;
        }
        return start + 1;
    }
}

