/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached;

import com.hikvision.cms.cache.core.memcached.IHealthManager;
import com.hikvision.cms.cache.core.memcached.NodeFailBackTask;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import net.rubyeye.xmemcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeHealthManager
implements IHealthManager {
    public static final Logger log = LoggerFactory.getLogger(NodeHealthManager.class);
    private ConcurrentHashMap<String, String> backingNodeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> downNodeMap = new ConcurrentHashMap();

    @Override
    public String addDownNode(InetSocketAddress nodeAddr) {
        if (nodeAddr == null || nodeAddr.getAddress() == null) {
            return "";
        }
        String node = nodeAddr.getAddress().getHostAddress() + ":" + nodeAddr.getPort();
        this.downNodeMap.put(node, node);
        return node;
    }

    @Override
    public String removeDownNode(InetSocketAddress nodeAddr) {
        if (nodeAddr == null || nodeAddr.getAddress() == null) {
            return "";
        }
        String node = nodeAddr.getAddress().getHostAddress() + ":" + nodeAddr.getPort();
        this.downNodeMap.remove(node);
        return node;
    }

    @Override
    public void failBack(MemcachedClient memcachedClient, InetSocketAddress inetSocketAddress, MemcachedCluster config) {
        NodeFailBackTask failback = new NodeFailBackTask(this, config, memcachedClient, inetSocketAddress);
        failback.start();
    }

    @Override
    public boolean isNodeDown(InetSocketAddress nodeAddr) {
        if (nodeAddr == null || nodeAddr.getAddress() == null) {
            return true;
        }
        String node = nodeAddr.getAddress().getHostAddress() + ":" + nodeAddr.getPort();
        return this.downNodeMap.containsKey(node) || this.backingNodeMap.containsKey(node);
    }

    @Override
    public boolean isNodeRealDown(InetSocketAddress nodeAddr) {
        if (nodeAddr == null || nodeAddr.getAddress() == null) {
            return true;
        }
        String node = nodeAddr.getAddress().getHostAddress() + ":" + nodeAddr.getPort();
        return this.downNodeMap.containsKey(node);
    }

    @Override
    public String addBackingNode(InetSocketAddress nodeAddr) {
        if (nodeAddr == null || nodeAddr.getAddress() == null) {
            return "";
        }
        String node = nodeAddr.getAddress().getHostAddress() + ":" + nodeAddr.getPort();
        this.downNodeMap.remove(node);
        this.backingNodeMap.put(node, node);
        return node;
    }

    @Override
    public String removeBackingNode(InetSocketAddress nodeAddr) {
        if (nodeAddr == null || nodeAddr.getAddress() == null) {
            return "";
        }
        String node = nodeAddr.getAddress().getHostAddress() + ":" + nodeAddr.getPort();
        this.backingNodeMap.remove(node);
        return node;
    }
}

