/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached;

import com.hikvision.cms.cache.core.memcached.IHealthManager;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import java.net.InetSocketAddress;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHealthMonitor
implements MemcachedClientStateListener {
    public static final Logger log = LoggerFactory.getLogger(SessionHealthMonitor.class);
    private MemcachedCluster cluster;

    public SessionHealthMonitor(MemcachedCluster cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected(MemcachedClient memcachedClient, InetSocketAddress inetSocketAddress) {
        log.info("Connect to " + inetSocketAddress);
        IHealthManager healthManager = this.cluster.getHealthManager();
        String string = inetSocketAddress.toString().intern();
        synchronized (string) {
            if (healthManager.isNodeDown(inetSocketAddress)) {
                log.info("start failback node:" + inetSocketAddress);
                healthManager.addBackingNode(inetSocketAddress);
                healthManager.failBack(memcachedClient, inetSocketAddress, this.cluster);
            }
        }
    }

    public void onDisconnected(MemcachedClient memcachedClient, InetSocketAddress inetSocketAddress) {
        log.info("DisConnect to " + inetSocketAddress);
        IHealthManager healthManager = this.cluster.getHealthManager();
        healthManager.addDownNode(inetSocketAddress);
    }

    public void onException(MemcachedClient memcachedClient, Throwable throwable) {
        log.info("onException ", throwable);
    }

    public void onShutDown(MemcachedClient memcachedClient) {
        log.info("onShutDown  " + memcachedClient.getName());
    }

    public void onStarted(MemcachedClient memcachedClient) {
        log.info("onStarted  " + memcachedClient.getName());
    }
}

