/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached.cluster;

import com.hikvision.cms.cache.core.AbstractCacheCluster;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.memcached.IHealthManager;
import com.hikvision.cms.cache.core.memcached.cluster.CacheServer;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.tools.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesMemcachedCluster
extends AbstractCacheCluster
implements MemcachedCluster {
    private int connectionPoolSize = 1;
    private long connectTimeout = 0L;
    private long optTimeout = 0L;
    private int receiveBuf = 0;
    private int sendBuf = 0;
    private Boolean tcpNodelay;
    private long sessionIdleTimeout = 0L;
    private int mergeFactor;
    private Boolean optimizeMergeBuffer;
    private Boolean enableHeartBeat;
    private Boolean enableStats;
    private IHealthManager healthManager;
    private int casKeyHash = 5;
    private String sessionServer = null;
    private String sessionStandbyServer = null;
    private boolean failBack = false;
    private Map<CacheConstants.DATA_TYPE, List<CacheServer>> serverMap;
    private Map<CacheConstants.DATA_TYPE, List<CacheServer>> backupServerMap;

    @Override
    public IHealthManager getHealthManager() {
        return this.healthManager;
    }

    @Override
    public void setHealthManager(IHealthManager healthManager) {
        this.healthManager = healthManager;
    }

    public PropertiesMemcachedCluster(Properties properties, String prefix) {
        super(properties, prefix);
        this.connectionPoolSize = StringUtil.toInteger(super.getValue(properties, "connection-pool-size"), this.connectionPoolSize);
        this.connectTimeout = StringUtil.toLong(super.getValue(properties, "connect-timeout"), this.connectTimeout);
        this.optTimeout = StringUtil.toLong(super.getValue(properties, "opt-timeout"), this.optTimeout);
        this.receiveBuf = StringUtil.toInteger(super.getValue(properties, "receive-buf"), this.receiveBuf);
        this.sendBuf = StringUtil.toInteger(super.getValue(properties, "send-buf"), this.sendBuf);
        this.tcpNodelay = StringUtil.toBoolean(super.getValue(properties, "tcp-nodelay"), this.tcpNodelay);
        this.sessionIdleTimeout = StringUtil.toLong(super.getValue(properties, "session-idle-timeout"), this.sessionIdleTimeout);
        this.mergeFactor = StringUtil.toInteger(super.getValue(properties, "merge-factor"), this.mergeFactor);
        this.optimizeMergeBuffer = StringUtil.toBoolean(super.getValue(properties, "optimize-merge-buffer"), this.optimizeMergeBuffer);
        this.enableHeartBeat = StringUtil.toBoolean(super.getValue(properties, "enable-heart-beat"), this.enableHeartBeat);
        this.enableStats = StringUtil.toBoolean(super.getValue(properties, "enable-stats"), this.enableStats);
        this.failBack = StringUtil.toBoolean(super.getValue(properties, "fail-back"), this.failBack);
        this.casKeyHash = StringUtil.toInteger(super.getValue(properties, "merge-factor"), this.casKeyHash);
        this.serverMap = this.handleServerList(properties, "server");
        this.sessionServer = super.getValue(properties, "session");
        this.sessionStandbyServer = super.getValue(properties, "session.standby");
    }

    private Map<CacheConstants.DATA_TYPE, List<CacheServer>> handleServerList(Properties properties, String serverTypeString) {
        HashMap<CacheConstants.DATA_TYPE, List<CacheServer>> map = new HashMap<CacheConstants.DATA_TYPE, List<CacheServer>>();
        String servers = super.getValue(properties, serverTypeString);
        if (StringUtil.isBlank((String)servers)) {
            return map;
        }
        this.handleServer(map, CacheConstants.DATA_TYPE.OTHER, servers);
        return map;
    }

    private void handleServer(Map<CacheConstants.DATA_TYPE, List<CacheServer>> map, CacheConstants.DATA_TYPE dataType, String servers) {
        String[] serverSplit;
        if (StringUtil.isBlank((String)servers)) {
            return;
        }
        for (String server : serverSplit = StringUtil.split((String)servers, (String)" ")) {
            if (StringUtil.isBlank((String)server)) continue;
            CacheServer cacheServer = new CacheServer();
            cacheServer.setDataType(dataType);
            String[] serverAddrs = StringUtil.split((String)server, (String)",");
            cacheServer.setMajor(serverAddrs[0]);
            if (serverAddrs.length > 1) {
                cacheServer.setBackup(serverAddrs[1]);
            }
            if (map.get((Object)cacheServer.getDataType()) == null) {
                map.put(cacheServer.getDataType(), new ArrayList());
            }
            map.get((Object)cacheServer.getDataType()).add(cacheServer);
        }
    }

    @Override
    public String[] getServers() {
        if (this.serverMap == null) {
            return null;
        }
        Iterator<List<CacheServer>> it = this.serverMap.values().iterator();
        return this.getServersByIt(it);
    }

    private String[] getServersByIt(Iterator<List<CacheServer>> it) {
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            for (CacheServer cacheServer : it.next()) {
                list.add(cacheServer.getMajor());
                if (!StringUtil.isNotBlank((String)cacheServer.getBackup())) continue;
                list.add(cacheServer.getBackup());
            }
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getBackupServers() {
        if (this.backupServerMap == null || this.backupServerMap.size() < 1) {
            return null;
        }
        Iterator<List<CacheServer>> it = this.backupServerMap.values().iterator();
        return this.getServersByIt(it);
    }

    @Override
    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public long getOptTimeout() {
        return this.optTimeout;
    }

    public void setOptTimeout(long optTimeout) {
        this.optTimeout = optTimeout;
    }

    @Override
    public int getReceiveBuf() {
        return this.receiveBuf;
    }

    public void setReceiveBuf(int receiveBuf) {
        this.receiveBuf = receiveBuf;
    }

    @Override
    public int getSendBuf() {
        return this.sendBuf;
    }

    public void setSendBuf(int sendBuf) {
        this.sendBuf = sendBuf;
    }

    @Override
    public Boolean getTcpNodelay() {
        return this.tcpNodelay;
    }

    public void setTcpNodelay(Boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
    }

    @Override
    public long getSessionIdleTimeout() {
        return this.sessionIdleTimeout;
    }

    public void setSessionIdleTimeout(long sessionIdleTimeout) {
        this.sessionIdleTimeout = sessionIdleTimeout;
    }

    @Override
    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    @Override
    public Boolean getOptimizeMergeBuffer() {
        return this.optimizeMergeBuffer;
    }

    public void setOptimizeMergeBuffer(Boolean optimizeMergeBuffer) {
        this.optimizeMergeBuffer = optimizeMergeBuffer;
    }

    @Override
    public Boolean getEnableHeartBeat() {
        return this.enableHeartBeat;
    }

    public void setEnableHeartBeat(Boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }

    @Override
    public Boolean getEnableStats() {
        return this.enableStats;
    }

    public void setEnableStats(Boolean enableStats) {
        this.enableStats = enableStats;
    }

    @Override
    public boolean isFailBack() {
        return this.failBack;
    }

    public void setFailBack(boolean failBack) {
        this.failBack = failBack;
    }

    @Override
    public Map<CacheConstants.DATA_TYPE, List<CacheServer>> getServerMap() {
        return this.serverMap;
    }

    public void setServerMap(Map<CacheConstants.DATA_TYPE, List<CacheServer>> serverMap) {
        this.serverMap = serverMap;
    }

    @Override
    public Map<CacheConstants.DATA_TYPE, List<CacheServer>> getBackupServerMap() {
        return this.backupServerMap;
    }

    public void setBackupServerMap(Map<CacheConstants.DATA_TYPE, List<CacheServer>> backupServerMap) {
        this.backupServerMap = backupServerMap;
    }

    @Override
    public int getCasKeyHash() {
        return this.casKeyHash;
    }

    public void setCasKeyHash(int casKeyHash) {
        this.casKeyHash = casKeyHash;
    }

    @Override
    public String getSessionServer() {
        return this.sessionServer;
    }

    public void setSessionServer(String sessionServer) {
        this.sessionServer = sessionServer;
    }

    @Override
    public String getSessionStandbyServer() {
        return this.sessionStandbyServer;
    }

    public void setSessionStandbyServer(String sessionStandbyServer) {
        this.sessionStandbyServer = sessionStandbyServer;
    }
}

