/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached.cluster;

import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.exception.DefinitionException;
import com.hikvision.cms.cache.core.memcached.IHealthManager;
import com.hikvision.cms.cache.core.memcached.cluster.CacheServer;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

@Deprecated
public class XmlMemcachedCluster
implements MemcachedCluster {
    private IHealthManager healthManager;
    private String cacheName = "memcache";
    private int connectionPoolSize = 0;
    private long connectTimeout = 0L;
    private long optTimeout = 0L;
    private int receiveBuf = 0;
    private int sendBuf = 0;
    private Boolean tcpNodelay;
    private long sessionIdleTimeout = 0L;
    private int mergeFactor;
    private Boolean optimizeMergeBuffer;
    private Boolean enableHeartBeat;
    private Boolean enableStats;
    private boolean failBack = false;
    private Map<CacheConstants.DATA_TYPE, List<CacheServer>> serverMap;
    private Map<CacheConstants.DATA_TYPE, List<CacheServer>> backupServerMap;

    @Override
    public String[] getServers() {
        if (this.serverMap == null) {
            return null;
        }
        Iterator<List<CacheServer>> it = this.serverMap.values().iterator();
        return this.getServersByIt(it);
    }

    private String[] getServersByIt(Iterator<List<CacheServer>> it) {
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            for (CacheServer cacheServer : it.next()) {
                list.add(cacheServer.getMajor());
                if (cacheServer.getBackup() == null) continue;
                list.add(cacheServer.getBackup());
            }
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getBackupServers() {
        if (this.backupServerMap == null || this.backupServerMap.size() < 1) {
            return null;
        }
        Iterator<List<CacheServer>> it = this.backupServerMap.values().iterator();
        return this.getServersByIt(it);
    }

    public static XmlMemcachedCluster build(String path) throws DefinitionException {
        XmlMemcachedCluster config = new XmlMemcachedCluster();
        Document doc = null;
        try {
            String filePath = path;
            File file = new File(filePath);
            if (file == null || !file.exists()) {
                file = new File("conf/" + path);
            }
            if (file == null || !file.exists()) {
                file = new File(URLDecoder.decode(XmlMemcachedCluster.class.getClassLoader().getResource(path).getPath(), "utf-8"));
            }
            if (file == null || !file.exists()) {
                throw new DefinitionException("\u52a0\u8f7dmemcached.conf.xml\u6587\u4ef6\u9519\u8bef!");
            }
            doc = new SAXReader().read(file);
        }
        catch (DocumentException e) {
            throw new DefinitionException("xml\u6587\u4ef6\u683c\u5f0f\u9519\u8bef-->", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new DefinitionException("xml\u6587\u4ef6\u683c\u5f0f\u9519\u8bef-->", e);
        }
        doc.selectSingleNode("/configuration");
        Element configurationElement = (Element)doc.selectSingleNode("/configuration");
        if ("".equalsIgnoreCase(configurationElement.attributeValue("version"))) {
            throw new DefinitionException("\u7248\u672c\u53f7\u9519\u8bef");
        }
        try {
            Node node;
            Node cacheName = doc.selectSingleNode("/configuration/cache-name");
            if (cacheName != null && StringUtils.isNotBlank((String)cacheName.getText())) {
                config.setCacheName(cacheName.getText());
            }
            if ((node = configurationElement.selectSingleNode("connection-pool-size")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setConnectionPoolSize(Integer.parseInt(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("connect-timeout")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setConnectTimeout(Long.parseLong(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("opt-timeout")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setOptTimeout(Long.parseLong(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("fail-back")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setFailBack(Boolean.parseBoolean(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("receive-buf")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setReceiveBuf(Integer.parseInt(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("send-buf")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setSendBuf(Integer.parseInt(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("tcp-nodelay")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setTcpNodelay(Boolean.parseBoolean(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("merge-factor")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setMergeFactor(Integer.parseInt(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("optimize-merge-buffer")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setOptimizeMergeBuffer(Boolean.parseBoolean(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("enable-heart-beat")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setEnableHeartBeat(Boolean.parseBoolean(node.getText()));
            }
            if ((node = configurationElement.selectSingleNode("enable-stats")) != null && StringUtils.isNotBlank((String)node.getText())) {
                config.setEnableStats(Boolean.parseBoolean(node.getText()));
            }
            Iterator<Element> serverNodeIt = configurationElement.selectNodes("server-list/server").iterator();
            config.setServerMap(XmlMemcachedCluster.handleServerList(serverNodeIt));
            Iterator<Element> backupserverNodeIt = configurationElement.selectNodes("backup-server-list/server").iterator();
            config.setBackupServerMap(XmlMemcachedCluster.handleServerList(backupserverNodeIt));
        }
        catch (IllegalArgumentException e) {
            throw new DefinitionException("\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef", e);
        }
        return config;
    }

    private static Map<CacheConstants.DATA_TYPE, List<CacheServer>> handleServerList(Iterator<Element> serverNodeIt) {
        HashMap<CacheConstants.DATA_TYPE, List<CacheServer>> serverMap = new HashMap<CacheConstants.DATA_TYPE, List<CacheServer>>();
        while (serverNodeIt.hasNext()) {
            Element serverNode = serverNodeIt.next();
            CacheServer cacheServer = new CacheServer();
            String type = serverNode.attributeValue("type");
            if (StringUtils.isNotBlank((String)type)) {
                cacheServer.setDataType(CacheConstants.DATA_TYPE.valueOf(type.toUpperCase(Locale.ENGLISH)));
            }
            String[] servers = StringUtils.split((String)serverNode.getTextTrim(), (String)",");
            cacheServer.setMajor(servers[0]);
            if (servers.length > 1) {
                cacheServer.setBackup(servers[1]);
            }
            if (serverMap.get((Object)cacheServer.getDataType()) == null) {
                serverMap.put(cacheServer.getDataType(), new ArrayList());
            }
            ((List)serverMap.get((Object)cacheServer.getDataType())).add(cacheServer);
        }
        return serverMap;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public long getOptTimeout() {
        return this.optTimeout;
    }

    public void setOptTimeout(long optTimeout) {
        this.optTimeout = optTimeout;
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public Map<CacheConstants.DATA_TYPE, List<CacheServer>> getServerMap() {
        return this.serverMap;
    }

    public void setServerMap(Map<CacheConstants.DATA_TYPE, List<CacheServer>> serverMap) {
        this.serverMap = serverMap;
    }

    @Override
    public Map<CacheConstants.DATA_TYPE, List<CacheServer>> getBackupServerMap() {
        return this.backupServerMap;
    }

    public void setBackupServerMap(Map<CacheConstants.DATA_TYPE, List<CacheServer>> backupServerMap) {
        this.backupServerMap = backupServerMap;
    }

    @Override
    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    @Override
    public boolean isFailBack() {
        return this.failBack;
    }

    public void setFailBack(boolean failBack) {
        this.failBack = failBack;
    }

    @Override
    public IHealthManager getHealthManager() {
        return this.healthManager;
    }

    @Override
    public void setHealthManager(IHealthManager healthManager) {
        this.healthManager = healthManager;
    }

    @Override
    public int getReceiveBuf() {
        return this.receiveBuf;
    }

    public void setReceiveBuf(int receiveBuf) {
        this.receiveBuf = receiveBuf;
    }

    @Override
    public int getSendBuf() {
        return this.sendBuf;
    }

    public void setSendBuf(int sendBuf) {
        this.sendBuf = sendBuf;
    }

    @Override
    public Boolean getTcpNodelay() {
        return this.tcpNodelay;
    }

    public void setTcpNodelay(Boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
    }

    @Override
    public long getSessionIdleTimeout() {
        return this.sessionIdleTimeout;
    }

    public void setSessionIdleTimeout(long sessionIdleTimeout) {
        this.sessionIdleTimeout = sessionIdleTimeout;
    }

    @Override
    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    @Override
    public Boolean getOptimizeMergeBuffer() {
        return this.optimizeMergeBuffer;
    }

    public void setOptimizeMergeBuffer(Boolean optimizeMergeBuffer) {
        this.optimizeMergeBuffer = optimizeMergeBuffer;
    }

    @Override
    public Boolean getEnableHeartBeat() {
        return this.enableHeartBeat;
    }

    public void setEnableHeartBeat(Boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }

    @Override
    public Boolean getEnableStats() {
        return this.enableStats;
    }

    public void setEnableStats(Boolean enableStats) {
        this.enableStats = enableStats;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public List<String> getDeploys() {
        return null;
    }

    @Override
    public int getCasKeyHash() {
        return 10;
    }

    @Override
    public String getSessionServer() {
        return null;
    }

    @Override
    public String getSessionStandbyServer() {
        return null;
    }
}

