/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached.locator;

import com.google.code.yanf4j.core.Session;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.memcached.cluster.CacheServer;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.memcached.locator.BackNextNodeMemcachedSessionLocator;
import com.hikvision.cms.cache.core.tools.KeyUtil;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.HashAlgorithm;

public class BackLonelyMemcachedSessionLocator
extends BackNextNodeMemcachedSessionLocator {
    private List<CacheServer> backupServerList = null;

    public BackLonelyMemcachedSessionLocator(MemcachedCluster cluster) {
        super(cluster);
        this.initNodeMap(this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.SESSION));
        this.backupServerList = this.cluster.getBackupServerMap().get((Object)CacheConstants.DATA_TYPE.OTHER);
    }

    public BackLonelyMemcachedSessionLocator(MemcachedCluster cluster, HashAlgorithm hashAlgorighm) {
        super(cluster, hashAlgorighm);
        this.initNodeMap(this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.SESSION));
        this.backupServerList = this.cluster.getBackupServerMap().get((Object)CacheConstants.DATA_TYPE.OTHER);
    }

    @Override
    public final void setHashAlgorighm(HashAlgorithm hashAlgorighm) {
        this.hashAlgorighm = hashAlgorighm;
    }

    @Override
    public Session getSessionByKey(String key) {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        Map sessionMap = this.sessions;
        if (KeyUtil.isStandByKey(key)) {
            return this.getBackupSession(sessionMap);
        }
        int size = this.serverList.size();
        if (size == 0) {
            return null;
        }
        long start = this.getHash(size, key);
        CacheServer server = (CacheServer)this.serverList.get((int)start);
        List sessions = (List)sessionMap.get(server.getMajor());
        Session session = this.getRandomSession(sessions);
        if (!this.failureMode && (session == null || session.isClosed())) {
            session = this.getBackupSession(sessionMap);
        }
        return session;
    }

    private Session getBackupSession(Map<String, List<Session>> sessionMap) {
        Session session = null;
        if (this.backupServerList != null && this.backupServerList.size() > 0) {
            CacheServer server = this.backupServerList.get(0);
            List<Session> sessions = sessionMap.get(server.getMajor());
            session = this.getRandomSession(sessions);
        }
        return session;
    }
}

