/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached.locator;

import com.google.code.yanf4j.core.Session;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.memcached.cluster.CacheServer;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.tools.KeyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.impl.AbstractMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackNextNodeMemcachedSessionLocator
extends AbstractMemcachedSessionLocator {
    protected static final Logger log = LoggerFactory.getLogger(BackNextNodeMemcachedSessionLocator.class);
    protected MemcachedCluster cluster;
    protected List<CacheServer> serverList = null;
    protected Map<String, String> sessionInNodeMap = new HashMap<String, String>();
    protected volatile transient Map<String, List<Session>> sessions;
    protected HashAlgorithm hashAlgorighm;
    protected final Random rand = new Random();

    public BackNextNodeMemcachedSessionLocator(MemcachedCluster cluster) {
        this.cluster = cluster;
        this.hashAlgorighm = HashAlgorithm.NATIVE_HASH;
        this.serverList = this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.OTHER);
        this.initNodeMap(this.serverList);
    }

    public BackNextNodeMemcachedSessionLocator(MemcachedCluster cluster, HashAlgorithm hashAlgorighm) {
        this.cluster = cluster;
        this.hashAlgorighm = hashAlgorighm;
        this.serverList = this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.OTHER);
        this.initNodeMap(this.serverList);
    }

    public void setHashAlgorighm(HashAlgorithm hashAlgorighm) {
        this.hashAlgorighm = hashAlgorighm;
    }

    protected void initNodeMap(List<CacheServer> serverList) {
        if (serverList == null) {
            return;
        }
        for (CacheServer server : serverList) {
            this.sessionInNodeMap.put(server.getMajor(), server.getMajor());
            if (server.getBackup() == null || server.getBackup().equals("")) continue;
            this.sessionInNodeMap.put(server.getBackup(), server.getMajor());
        }
    }

    public long getHash(int size, String key) {
        long hash = this.hashAlgorighm.hash(key);
        return hash % (long)size;
    }

    protected Session getRandomSession(List<Session> sessions) {
        if (sessions == null || sessions.isEmpty()) {
            return null;
        }
        Session session = sessions.get(this.rand.nextInt(sessions.size()));
        if (this.cluster.getHealthManager().isNodeDown(session.getRemoteSocketAddress())) {
            return null;
        }
        return session;
    }

    public Session getSessionByKey(String key) {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        Map<String, List<Session>> sessionMap = this.sessions;
        int size = this.serverList.size();
        if (size == 0) {
            return null;
        }
        Session session = null;
        CacheServer server = null;
        boolean isStandBy = KeyUtil.isStandByKey(key);
        if (isStandBy) {
            key = key.replace("_&SB", "");
        }
        long start = this.getHash(size, key);
        boolean isList = KeyUtil.isListKey(key);
        if (isList) {
            start = 0L;
        }
        if (isList || !isStandBy) {
            server = this.serverList.get((int)start);
            List<Session> sessionList = sessionMap.get(server.getMajor());
            session = this.getRandomSession(sessionList);
        }
        if (!(this.failureMode || session != null && !session.isClosed() || KeyUtil.hasPersistence(key))) {
            long next = this.getNext(size, start);
            server = this.serverList.get((int)next);
            while ((session == null || session.isClosed()) && next != start) {
                List<Session> sessionList = sessionMap.get(server.getMajor());
                session = this.getRandomSession(sessionList);
                next = this.getNext(size, next);
            }
        }
        return session;
    }

    public final long getNext(int size, long start) {
        if (start == (long)(size - 1)) {
            return 0L;
        }
        return start + 1L;
    }

    public void updateSessions(Collection<Session> list) {
        if (list == null || list.isEmpty()) {
            log.debug("update session: list is empty");
            this.sessions = Collections.emptyMap();
            return;
        }
        log.debug("update session\uff0clist size: {}", (Object)list.size());
        Collection<Session> copySessions = list;
        HashMap tmpMap = new HashMap();
        Session target = null;
        ArrayList<Session> subList = null;
        String targetKey = null;
        for (Session session : copySessions) {
            if (target == null) {
                target = session;
                subList = new ArrayList<Session>();
                subList.add(target);
                targetKey = target.getRemoteSocketAddress().getAddress().getHostAddress() + ":" + target.getRemoteSocketAddress().getPort();
                continue;
            }
            String sessionKey = session.getRemoteSocketAddress().getAddress().getHostAddress() + ":" + session.getRemoteSocketAddress().getPort();
            targetKey = target.getRemoteSocketAddress().getAddress().getHostAddress() + ":" + target.getRemoteSocketAddress().getPort();
            if (this.sessionInNodeMap.get(sessionKey).equals(this.sessionInNodeMap.get(targetKey))) {
                subList.add(session);
                continue;
            }
            tmpMap.put(this.sessionInNodeMap.get(targetKey), subList);
            target = session;
            subList = new ArrayList();
            subList.add(target);
        }
        if (subList != null) {
            targetKey = target.getRemoteSocketAddress().getAddress().getHostAddress() + ":" + target.getRemoteSocketAddress().getPort();
            tmpMap.put(this.sessionInNodeMap.get(targetKey), subList);
        }
        HashMap<String, List<Session>> newSessions = new HashMap<String, List<Session>>();
        for (Map.Entry entry : tmpMap.entrySet()) {
            List sessions = (List)entry.getValue();
            if (sessions == null || sessions.isEmpty()) continue;
            Session session = (Session)sessions.get(0);
            if (session instanceof MemcachedTCPSession) {
                int weight = ((MemcachedSession)session).getWeight();
                for (int i = 0; i < weight; ++i) {
                    newSessions.put((String)entry.getKey(), sessions);
                }
                continue;
            }
            newSessions.put((String)entry.getKey(), sessions);
        }
        this.sessions = newSessions;
    }
}

