/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memcached.locator;

import com.google.code.yanf4j.core.Session;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.memcached.cluster.CacheServer;
import com.hikvision.cms.cache.core.memcached.cluster.MemcachedCluster;
import com.hikvision.cms.cache.core.memcached.locator.BackNextNodeMemcachedSessionLocator;
import com.hikvision.cms.cache.core.tools.KeyUtil;
import java.util.List;
import java.util.Map;
import net.rubyeye.xmemcached.HashAlgorithm;

public class BackSessionLonlyMemcachedSessionLocator
extends BackNextNodeMemcachedSessionLocator {
    protected List<CacheServer> sessionServerList = null;

    public BackSessionLonlyMemcachedSessionLocator(MemcachedCluster cluster) {
        super(cluster);
        this.sessionServerList = this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.SESSION);
        this.initNodeMap(this.sessionServerList);
    }

    public BackSessionLonlyMemcachedSessionLocator(MemcachedCluster cluster, HashAlgorithm hashAlgorighm) {
        super(cluster, hashAlgorighm);
        this.sessionServerList = this.cluster.getServerMap().get((Object)CacheConstants.DATA_TYPE.SESSION);
        this.initNodeMap(this.sessionServerList);
    }

    @Override
    public Session getSessionByKey(String key) {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        Map sessionMap = this.sessions;
        List<CacheServer> servers = null;
        servers = KeyUtil.hasPersistence(key) ? this.serverList : this.sessionServerList;
        int size = servers.size();
        if (size == 0) {
            return null;
        }
        Session session = null;
        CacheServer server = null;
        boolean isStandBy = KeyUtil.isStandByKey(key);
        if (isStandBy) {
            key = key.replace("_&SB", "");
        }
        long start = this.getHash(size, key);
        if (!isStandBy) {
            server = servers.get((int)start);
            List sessionList = (List)sessionMap.get(server.getMajor());
            session = this.getRandomSession(sessionList);
        }
        if (!this.failureMode && (session == null || session.isClosed())) {
            long next = this.getNext(size, start);
            server = servers.get((int)next);
            while ((session == null || session.isClosed()) && next != start) {
                List sessionList = (List)sessionMap.get(server.getMajor());
                session = this.getRandomSession(sessionList);
                next = this.getNext(size, next);
            }
        }
        return session;
    }
}

