/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.memory;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMemoryCache<K, V> {
    private Logger log = LoggerFactory.getLogger(SimpleMemoryCache.class);
    private final Lock lock = new ReentrantLock();
    private final int maxCapacity;
    private final Map<K, V> eden;
    private final Map<K, V> longterm;

    public SimpleMemoryCache(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.eden = new ConcurrentHashMap(maxCapacity);
        this.longterm = new WeakHashMap(maxCapacity);
    }

    public Map<K, V> getEdenMap() {
        return this.eden;
    }

    public Map<K, V> getLongTermMap() {
        return this.longterm;
    }

    public void remove(List<String> keyList) {
        if (!CollectionUtils.isEmpty(keyList)) {
            for (String key : keyList) {
                this.remove(key);
            }
        }
    }

    public V get(K k) {
        V v = this.eden.get(k);
        if (v == null) {
            this.lock.lock();
            try {
                v = this.longterm.get(k);
            }
            finally {
                this.lock.unlock();
            }
            if (v != null) {
                this.eden.put(k, v);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("get key [{}],value is:{}", new Object[]{k, String.valueOf(v)});
        }
        return v;
    }

    public void put(K k, V v) {
        if (this.eden.size() >= this.maxCapacity) {
            this.lock.lock();
            try {
                this.longterm.putAll(this.eden);
            }
            finally {
                this.lock.unlock();
            }
            this.eden.clear();
        }
        this.eden.put(k, v);
        if (this.log.isDebugEnabled()) {
            this.log.debug("get key [{}],value is:{}", new Object[]{k, String.valueOf(v)});
        }
    }

    public void remove(String key) {
        this.lock.lock();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("remove key [{}]", new Object[]{key});
            }
            this.longterm.remove(key);
            this.eden.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }
}

