/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.redis.cluster;

import com.hikvision.cms.cache.core.AbstractCacheCluster;
import com.hikvision.cms.cache.core.redis.cluster.RedisCluster;
import com.hikvision.cms.cache.core.tools.StringUtil;
import com.ivms6.core.util.NumberUtils;
import java.util.Properties;

public class PropertiesRedisCluster
extends AbstractCacheCluster
implements RedisCluster {
    private String connectionIp = "127.0.0.1";
    private int connectionPort = 6379;
    private int connectionPoolSize = 1;
    private int connectionMaxIdle = 1;
    private int connectionMinIdle = 1;
    private String connectionAuth;

    public PropertiesRedisCluster(Properties properties, String prefix) {
        super(properties, prefix);
        String str = super.getValue(properties, "server");
        this.connectionIp = str.split(":")[0];
        this.connectionPort = NumberUtils.toInt((String)str.split(":")[1], (int)this.connectionPort);
        this.connectionPoolSize = StringUtil.toInteger(super.getValue(properties, "connection-pool-size"), this.connectionPoolSize);
        this.connectionMaxIdle = StringUtil.toInteger(super.getValue(properties, "connect-max-idle"), this.connectionMaxIdle);
        this.connectionMinIdle = StringUtil.toInteger(super.getValue(properties, "connect-min-idle"), this.connectionMinIdle);
        this.connectionAuth = super.getValue(properties, "auth");
    }

    @Override
    public String getConnectionIp() {
        return this.connectionIp;
    }

    @Override
    public int getConnectionPort() {
        return this.connectionPort;
    }

    @Override
    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    @Override
    public int getConnectionMaxIdle() {
        return this.connectionMaxIdle;
    }

    @Override
    public int getConnectionMinIdle() {
        return this.connectionMinIdle;
    }

    @Override
    public String getConnectAuth() {
        return this.connectionAuth;
    }
}

