/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.tools;

import com.hikvision.cms.cache.core.CacheConnectFactory;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.tools.KeyUtil;

public class CacheUtil {
    public static Object get(String key) throws CacheConnectException {
        return CacheConnectFactory.getCache().get(KeyUtil.getKeyPre() + key);
    }

    public static Object get(String key, CacheConstants.DATA_TYPE tt) throws CacheConnectException {
        return CacheConnectFactory.getCache().get(KeyUtil.getKeyPre(tt) + key);
    }

    public static Object get(String deployId, String key) throws CacheConnectException {
        return CacheConnectFactory.getCache(deployId).get(KeyUtil.getKeyPre(deployId) + key);
    }

    public static Object get(String deployId, String key, CacheConstants.DATA_TYPE tt) throws CacheConnectException {
        return CacheConnectFactory.getCache(deployId).get(KeyUtil.getKeyPre(deployId, tt) + key);
    }

    public static Object getKey(String key) throws CacheConnectException {
        return CacheConnectFactory.getCache().get(key);
    }

    public static Object getKey(String deployId, String key) throws CacheConnectException {
        return CacheConnectFactory.getCache(deployId).get(key);
    }

    public static void set(String key, Object value) throws CacheConnectException {
        CacheConnectFactory.getCache().set(KeyUtil.getKeyPre() + key, value);
    }

    public static void set(String deployId, String key, Object value) throws CacheConnectException {
        CacheConnectFactory.getCache(deployId).set(KeyUtil.getKeyPre(deployId) + key, value);
    }

    public static void set(String key, Object value, CacheConstants.DATA_TYPE tt) throws CacheConnectException {
        CacheConnectFactory.getCache().set(KeyUtil.getKeyPre(tt) + key, value);
    }

    public static void set(String deployId, String key, Object value, CacheConstants.DATA_TYPE tt) throws CacheConnectException {
        CacheConnectFactory.getCache(deployId).set(KeyUtil.getKeyPre(deployId, tt) + key, value);
    }

    public static void set(String key, Object value, long expire, CacheConstants.DATA_TYPE tt) throws CacheConnectException {
        CacheConnectFactory.getCache().set(KeyUtil.getKeyPre(tt) + key, value, expire);
    }

    public static void set(String key, Object value, long expiry) throws CacheConnectException {
        CacheConnectFactory.getCache().set(KeyUtil.getKeyPre() + key, value, expiry);
    }

    public static void set(String deployId, String key, Object value, long expiry) throws CacheConnectException {
        CacheConnectFactory.getCache(deployId).set(KeyUtil.getKeyPre(deployId) + key, value, expiry);
    }

    public static void delete(String key) throws CacheConnectException {
        CacheConnectFactory.getCache().remove(KeyUtil.getKeyPre() + key);
    }

    public static void delete(String key, CacheConstants.DATA_TYPE tt) throws CacheConnectException {
        CacheConnectFactory.getCache().remove(KeyUtil.getKeyPre(tt) + key);
    }

    public static void delete(String deployId, String key) throws CacheConnectException {
        CacheConnectFactory.getCache(deployId).remove(KeyUtil.getKeyPre(deployId) + key);
    }

    public static void clear() throws CacheConnectException {
        CacheConnectFactory.getCache().clear();
    }

    public static void clear(String deployId) throws CacheConnectException {
        CacheConnectFactory.getCache(deployId).clear();
    }

    public static String[] getList(String key) throws CacheConnectException {
        return CacheConnectFactory.getCache().getList(KeyUtil.getKeyPre() + key);
    }

    public static String[] getList(String deployId, String key) throws CacheConnectException {
        return CacheConnectFactory.getCache(deployId).getList(KeyUtil.getKeyPre(deployId) + key);
    }

    public static void addToList(String key, String value) throws CacheConnectException {
        CacheConnectFactory.getCache().addToList(KeyUtil.getKeyPre() + key, value);
    }

    public static void addToList(String deployId, String key, String value) throws CacheConnectException {
        CacheConnectFactory.getCache(deployId).addToList(KeyUtil.getKeyPre(deployId) + key, value);
    }

    public static void removeFromList(String key, String value) throws CacheConnectException {
        CacheConnectFactory.getCache().removeFromList(KeyUtil.getKeyPre() + key, value);
    }

    public static void removeFromList(String deployId, String key, String value) throws CacheConnectException {
        CacheConnectFactory.getCache(deployId).removeFromList(KeyUtil.getKeyPre(deployId) + key, value);
    }
}

