/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.tools;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoXmlUtil {
    private static final Logger log = LoggerFactory.getLogger(DtoXmlUtil.class);
    private static final String xmlRowHead = "<row ";
    private static final String xmlRowEnd = "/>";
    private static final String xmlClassName = "className";

    public static String dtoToXml(Object dto) {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append(xmlRowHead);
        PropertyDescriptor[] props = null;
        try {
            props = Introspector.getBeanInfo(dto.getClass(), Object.class).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            log.error("load beanInfo error:", (Throwable)e);
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getName();
                String value = null;
                try {
                    value = DtoXmlUtil.objectToXml(props[i].getReadMethod().invoke(dto, new Object[0]));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (!StringUtils.isNotBlank((String)name) || !StringUtils.isNotBlank(value)) continue;
                xmlBuilder.append(name);
                xmlBuilder.append("=\"");
                xmlBuilder.append(value);
                xmlBuilder.append("\" ");
            }
        }
        xmlBuilder.append(xmlRowEnd);
        return xmlBuilder.toString();
    }

    public static String objectToXml(Object object) {
        String xmlBuilder = "";
        if (object != null) {
            if (object instanceof String) {
                xmlBuilder = (String)object;
            } else if (object instanceof Integer || object instanceof Short || object instanceof Boolean || object instanceof Long || object instanceof Byte) {
                xmlBuilder = object.toString();
            }
        }
        return xmlBuilder;
    }

    public static Object xmlToDto(String xml) throws Exception {
        List rowNodes;
        if (StringUtils.isBlank((String)xml)) {
            return null;
        }
        StringReader stringReader = new StringReader(xml.toString());
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((Reader)stringReader);
        Object object = null;
        if (document != null && (rowNodes = document.selectNodes("//row")) != null && rowNodes.size() > 0) {
            Element rowData = (Element)rowNodes.get(0);
            List attrs = rowData.attributes();
            for (int i = 0; i < attrs.size(); ++i) {
                AbstractAttribute attr = (AbstractAttribute)attrs.get(i);
                if (!attr.getName().equals(xmlClassName)) continue;
                object = Class.forName(attr.getValue()).newInstance();
                break;
            }
            if (object != null) {
                PropertyDescriptor[] props = null;
                props = Introspector.getBeanInfo(object.getClass(), Object.class).getPropertyDescriptors();
                if (props != null) {
                    block1: for (int i = 0; i < props.length; ++i) {
                        for (int j = 0; j < attrs.size(); ++j) {
                            AbstractAttribute attr = (AbstractAttribute)attrs.get(j);
                            if (!props[i].getName().equals(attr.getName()) || props[i].getWriteMethod() == null) continue;
                            if (props[i].getPropertyType().getName().equals("java.lang.String")) {
                                props[i].getWriteMethod().invoke(object, attr.getValue());
                                continue block1;
                            }
                            if (props[i].getPropertyType().getName().equals("java.lang.Integer")) {
                                props[i].getWriteMethod().invoke(object, Integer.parseInt(attr.getValue()));
                                continue block1;
                            }
                            if (props[i].getPropertyType().getName().equals("java.lang.Short")) {
                                props[i].getWriteMethod().invoke(object, Short.parseShort(attr.getValue()));
                                continue block1;
                            }
                            if (props[i].getPropertyType().getName().equals("java.lang.Boolean")) {
                                props[i].getWriteMethod().invoke(object, Boolean.parseBoolean(attr.getValue()));
                                continue block1;
                            }
                            if (props[i].getPropertyType().getName().equals("java.lang.Long")) {
                                props[i].getWriteMethod().invoke(object, Long.parseLong(attr.getValue()));
                                continue block1;
                            }
                            if (!props[i].getPropertyType().getName().equals("java.lang.Byte")) continue block1;
                            props[i].getWriteMethod().invoke(object, Byte.parseByte(attr.getValue()));
                            continue block1;
                        }
                    }
                }
            }
        }
        return object;
    }

    public static void main(String[] args) {
    }
}

