/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.core.tools;

import com.hikvision.cms.cache.core.CacheConnectFactory;
import com.hikvision.cms.cache.core.common.CacheConstants;

public class KeyUtil {
    public static final String KEY_SPLIT_S = "#";
    public static final String KEY_SPLIT_D = "$";
    public static final String KEY_SPLIT_KEY = "k";

    public static boolean hasPersistence(String key) {
        if (key == null || key.equals("")) {
            return true;
        }
        String[] keyItems = key.split(KEY_SPLIT_S);
        if (keyItems == null || keyItems.length < 2) {
            return true;
        }
        String dataType = keyItems[1];
        return !dataType.equals(CacheConstants.DATA_TYPE.SESSION.ordinal() + "");
    }

    public static boolean isSession(String key) {
        if (key == null || key.equals("")) {
            return false;
        }
        String[] keyItems = key.split(KEY_SPLIT_S);
        if (keyItems == null || keyItems.length < 2) {
            return false;
        }
        String dataType = keyItems[1];
        return dataType.equals(CacheConstants.DATA_TYPE.SESSION.ordinal() + "");
    }

    public static String getKeyPre() {
        return CacheConnectFactory.getDeployName() + KEY_SPLIT_S + CacheConstants.DATA_TYPE.SESSION.ordinal() + KEY_SPLIT_S;
    }

    public static String getKeyPre(CacheConstants.DATA_TYPE type) {
        return CacheConnectFactory.getDeployName() + KEY_SPLIT_S + type.ordinal() + KEY_SPLIT_S;
    }

    public static String getKeyPre(String deployId) {
        return CacheConnectFactory.getDeployName(deployId) + KEY_SPLIT_S + CacheConstants.DATA_TYPE.SESSION.ordinal() + KEY_SPLIT_S;
    }

    public static String getKeyPre(String deployId, CacheConstants.DATA_TYPE type) {
        return CacheConnectFactory.getDeployName(deployId) + KEY_SPLIT_S + type.ordinal() + KEY_SPLIT_S;
    }

    public static String getObjectKey(String fullKey) {
        return fullKey.substring(fullKey.lastIndexOf(KEY_SPLIT_D) + 1);
    }

    public static boolean isStandByKey(String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        return key.endsWith("_&SB");
    }

    public static boolean isListKey(String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        return key.endsWith("_&LE");
    }
}

