/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.manager;

import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.manager.DataLoadException;
import com.hikvision.cms.cache.manager.IDataStore;
import com.ivms6.core.util.cm.ConfigManager;

public class DataManager {
    private IDataStore memoryStore;
    private IDataStore dbStore;
    private IDataStore thirdPartyStore;
    private String config = null;

    public boolean isThirdStore() {
        if (this.config == null) {
            this.config = ConfigManager.getConfiguration((String)"cache-store", (String)"cache.thirdpart");
        }
        return "true".equals(this.config);
    }

    private IDataStore getStore(boolean single) {
        if (this.isThirdStore()) {
            return this.thirdPartyStore;
        }
        if (single) {
            return this.memoryStore;
        }
        return this.dbStore;
    }

    public boolean set(String key, String value) throws DataLoadException {
        return this.getStore(true).set(key, value);
    }

    public boolean set(String key, String value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getStore(true).set(key, value, type);
    }

    public boolean set(String key, String value, long exp) throws DataLoadException {
        return this.getStore(true).set(key, value, exp);
    }

    public boolean set(String key, String value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getStore(true).set(key, value, exp, type);
    }

    public String get(String key) throws DataLoadException {
        return this.getStore(true).get(key);
    }

    public String get(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getStore(true).get(key, type);
    }

    public boolean remove(String key) throws DataLoadException {
        return this.getStore(true).remove(key);
    }

    public boolean remove(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getStore(true).remove(key, type);
    }

    public boolean setObject(String key, Object value) throws DataLoadException {
        return this.getStore(true).setObject(key, value);
    }

    public boolean setObject(String key, Object value, long exp) throws DataLoadException {
        return this.getStore(true).setObject(key, value, exp);
    }

    public boolean setObject(String key, Object value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getStore(true).setObject(key, value, type);
    }

    public boolean setObject(String key, Object value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getStore(true).setObject(key, value, exp, type);
    }

    public Object getObject(String key) throws DataLoadException {
        return this.getStore(true).getObject(key);
    }

    public Object getObject(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getStore(true).getObject(key, type);
    }

    public boolean set(String key, String value, boolean single) throws DataLoadException {
        return this.getStore(single).set(key, value);
    }

    public boolean set(String key, String value, CacheConstants.DATA_TYPE type, boolean single) throws DataLoadException {
        return this.getStore(single).set(key, value, type);
    }

    public boolean set(String key, String value, long exp, boolean single) throws DataLoadException {
        return this.getStore(single).set(key, value, exp);
    }

    public boolean set(String key, String value, long exp, CacheConstants.DATA_TYPE type, boolean single) throws DataLoadException {
        return this.getStore(single).set(key, value, exp, type);
    }

    public String get(String key, boolean single) throws DataLoadException {
        return this.getStore(single).get(key);
    }

    public String get(String key, CacheConstants.DATA_TYPE type, boolean single) throws DataLoadException {
        return this.getStore(single).get(key, type);
    }

    public boolean remove(String key, boolean single) throws DataLoadException {
        return this.getStore(single).remove(key);
    }

    public boolean remove(String key, CacheConstants.DATA_TYPE type, boolean single) throws DataLoadException {
        return this.getStore(single).remove(key, type);
    }

    public boolean setObject(String key, Object value, boolean single) throws DataLoadException {
        return this.getStore(single).setObject(key, value);
    }

    public boolean setObject(String key, Object value, long exp, boolean single) throws DataLoadException {
        return this.getStore(single).setObject(key, value, exp);
    }

    public boolean setObject(String key, Object value, CacheConstants.DATA_TYPE type, boolean single) throws DataLoadException {
        return this.getStore(single).setObject(key, value, type);
    }

    public boolean setObject(String key, Object value, long exp, CacheConstants.DATA_TYPE type, boolean single) throws DataLoadException {
        return this.getStore(single).setObject(key, value, exp, type);
    }

    public Object getObject(String key, boolean single) throws DataLoadException {
        return this.getStore(single).getObject(key);
    }

    public Object getObject(String key, CacheConstants.DATA_TYPE type, boolean single) throws DataLoadException {
        return this.getStore(single).getObject(key, type);
    }

    public IDataStore getMemoryStore() {
        return this.memoryStore;
    }

    public void setMemoryStore(IDataStore memoryStore) {
        this.memoryStore = memoryStore;
    }

    public IDataStore getDbStore() {
        return this.dbStore;
    }

    public void setDbStore(IDataStore dbStore) {
        this.dbStore = dbStore;
    }

    public IDataStore getThirdPartyStore() {
        return this.thirdPartyStore;
    }

    public void setThirdPartyStore(IDataStore thirdPartyStore) {
        this.thirdPartyStore = thirdPartyStore;
    }
}

