/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.manager;

import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.exception.CacheConnectException;
import com.hikvision.cms.cache.core.tools.CacheUtil;
import com.hikvision.cms.cache.manager.DataLoadException;
import com.hikvision.cms.cache.manager.IDataStore;
import com.hikvision.cms.cache.manager.serialize.XmlSerializer;
import com.ivms6.core.util.StringUtils;
import com.thoughtworks.xstream.XStreamException;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheStore
implements IDataStore {
    private Logger log = LoggerFactory.getLogger(MemcacheStore.class);
    private XmlSerializer serializer = new XmlSerializer();

    @Override
    public String get(String key) throws DataLoadException {
        try {
            return (String)CacheUtil.get(key);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, "", e, "get");
            throw new DataLoadException(e);
        }
    }

    private void recordSystemLog(String key, String value, Throwable ce, String action) {
        this.log.info("write system log for cache error.key:" + key + ",value:" + value);
    }

    @Override
    public boolean set(String key, String value) throws DataLoadException {
        return this.set(key, value, 0L);
    }

    @Override
    public boolean set(String key, String value, long exp) throws DataLoadException {
        try {
            CacheUtil.set(key, (Object)value, exp);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, value, e, "set");
            throw new DataLoadException(e);
        }
        return true;
    }

    @Override
    public boolean remove(String key) throws DataLoadException {
        try {
            CacheUtil.delete(key);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, "", e, "remove");
            throw new DataLoadException(e);
        }
        return true;
    }

    @Override
    public String get(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        try {
            return (String)CacheUtil.get(key, type);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, "", e, "get");
            throw new DataLoadException(e);
        }
    }

    @Override
    public boolean remove(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        try {
            CacheUtil.delete(key, type);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, "", e, "remove");
            throw new DataLoadException(e);
        }
        return true;
    }

    @Override
    public boolean set(String key, String value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        try {
            CacheUtil.set(key, (Object)value, type);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, value, e, "set");
            throw new DataLoadException(e);
        }
        return true;
    }

    @Override
    public boolean set(String key, String value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        try {
            CacheUtil.set(key, (Object)value, exp, type);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, value, e, "set");
            throw new DataLoadException(e);
        }
        return true;
    }

    @Override
    public Object getObject(String key) throws DataLoadException {
        return this.getObject(key, CacheConstants.DATA_TYPE.TEMP);
    }

    @Override
    public boolean setObject(String key, Object value) throws DataLoadException {
        return this.setObject(key, value, 0L, CacheConstants.DATA_TYPE.TEMP);
    }

    @Override
    public boolean setObject(String key, Object value, long exp) throws DataLoadException {
        return this.setObject(key, value, exp, CacheConstants.DATA_TYPE.TEMP);
    }

    @Override
    public boolean setObject(String key, Object value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        String xml = "";
        try {
            xml = this.serializer.serialize(value);
            if (StringUtils.isEmpty((String)xml)) {
                return false;
            }
            try {
                if (xml.getBytes("utf-8").length > 1000000) {
                    DataLoadException e = new DataLoadException("object is too big to save.");
                    this.recordSystemLog(key, xml, e, "setObject");
                    throw e;
                }
            }
            catch (UnsupportedEncodingException e) {
                this.recordSystemLog(key, xml, e, "setObject");
                throw new DataLoadException("object is illegal.", e);
            }
            CacheUtil.set(key, (Object)xml, exp, type);
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, xml, e, "setObject");
            throw new DataLoadException(e);
        }
        catch (XStreamException e) {
            this.recordSystemLog(key, xml, e, "setObject");
            throw new DataLoadException("serialized value error.", e);
        }
        return false;
    }

    @Override
    public Object getObject(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        try {
            String xml = (String)CacheUtil.get(key, type);
            Object value = this.serializer.unSerialize(xml);
            return value;
        }
        catch (CacheConnectException e) {
            this.recordSystemLog(key, "", e, "getObject");
            throw new DataLoadException(e);
        }
        catch (XStreamException e) {
            this.recordSystemLog(key, "", e, "setObject");
            throw new DataLoadException("deserialized value error.", e);
        }
    }

    @Override
    public boolean setObject(String key, Object value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.setObject(key, value, 0L, type);
    }
}

