/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.manager;

import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.core.memory.SimpleMemoryCache;
import com.hikvision.cms.cache.manager.DataLoadException;
import com.hikvision.cms.cache.manager.IDataStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
implements IDataStore {
    private Logger log = LoggerFactory.getLogger(MemoryStore.class);
    private static SimpleMemoryCache<String, TimeObject> dataStore = new SimpleMemoryCache(10000);
    private static final long NEVER_EXPIRE = 2592000000L;
    private static long checkTime = 0L;
    private static final long CHECK_PERIOD = 30000L;

    private boolean isNeedCheck() {
        long now = System.currentTimeMillis();
        if (now - checkTime > 30000L) {
            this.log.info("start clear expire data.");
            ExpireDataCleaner cleaner = new ExpireDataCleaner();
            cleaner.start();
            checkTime = now;
            return true;
        }
        return false;
    }

    @Override
    public String get(String key) throws DataLoadException {
        this.isNeedCheck();
        TimeObject value = dataStore.get(key);
        if (value == null || value.isExpire()) {
            return null;
        }
        return String.valueOf(value.getData());
    }

    @Override
    public boolean set(String key, String value) throws DataLoadException {
        this.setObject(key, value);
        return true;
    }

    @Override
    public boolean set(String key, String value, long exp) throws DataLoadException {
        this.setObject(key, (Object)value, exp);
        return true;
    }

    @Override
    public boolean remove(String key) {
        dataStore.remove(key);
        return true;
    }

    @Override
    public String get(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.get(key);
    }

    @Override
    public boolean remove(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.remove(key);
    }

    @Override
    public boolean set(String key, String value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.set(key, value);
    }

    @Override
    public boolean set(String key, String value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.set(key, value, exp);
    }

    @Override
    public Object getObject(String key) throws DataLoadException {
        this.isNeedCheck();
        TimeObject value = dataStore.get(key);
        if (value == null || value.isExpire()) {
            return null;
        }
        return value.getData();
    }

    @Override
    public boolean setObject(String key, Object value) throws DataLoadException {
        TimeObject data = new TimeObject(value, 2592000000L);
        long now = System.currentTimeMillis();
        data.setUpdateTime(now);
        dataStore.put(key, data);
        return true;
    }

    @Override
    public boolean setObject(String key, Object value, long exp) throws DataLoadException {
        TimeObject data = new TimeObject(value, exp);
        long now = System.currentTimeMillis();
        data.setUpdateTime(now);
        dataStore.put(key, data);
        return true;
    }

    @Override
    public boolean setObject(String key, Object value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        TimeObject data = new TimeObject(value, exp);
        long now = System.currentTimeMillis();
        data.setUpdateTime(now);
        dataStore.put(key, data);
        return true;
    }

    @Override
    public Object getObject(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getObject(key);
    }

    @Override
    public boolean setObject(String key, Object value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.setObject(key, value);
    }

    class ExpireDataCleaner
    extends Thread {
        ExpireDataCleaner() {
        }

        private void putExpireData2List(Map<String, TimeObject> dataMap, List<String> container) {
            if (dataMap == null || dataMap.size() < 1) {
                return;
            }
            for (Map.Entry<String, TimeObject> entry : dataMap.entrySet()) {
                String key = entry.getKey();
                TimeObject to = entry.getValue();
                if (!to.isExpire()) continue;
                if (MemoryStore.this.log.isDebugEnabled()) {
                    MemoryStore.this.log.debug("the value [{}] is expired", new Object[]{key});
                }
                container.add(key);
            }
        }

        @Override
        public void run() {
            ArrayList<String> container = new ArrayList<String>();
            Map<String, TimeObject> edenMap = dataStore.getEdenMap();
            Map<String, TimeObject> longTermMap = dataStore.getLongTermMap();
            this.putExpireData2List(edenMap, container);
            this.putExpireData2List(longTermMap, container);
            dataStore.remove(container);
        }
    }

    class TimeObject {
        private long updateTime = -1L;
        private long expire = 0L;
        private Object data;

        public boolean isExpire() {
            long now = System.currentTimeMillis();
            return now > this.expire + this.updateTime;
        }

        public TimeObject(Object data) {
            this.data = data;
        }

        public TimeObject(Object data, long expire) {
            this.data = data;
            this.expire = expire;
        }

        public long getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(long updateTime) {
            this.updateTime = updateTime;
        }

        public long getExpire() {
            return this.expire;
        }

        public void setExpire(long expire) {
            this.expire = expire;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public String toString() {
            return String.valueOf(this.data);
        }
    }
}

