/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.manager;

import com.alibaba.fastjson.JSON;
import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.manager.DataLoadException;
import com.hikvision.cms.cache.manager.IDataStoreForCollection;
import com.hikvision.cms.cache.manager.serialize.JsonDto;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.NumberUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisStore
implements IDataStoreForCollection {
    JedisPool jedisPool;
    static int DEFAULT_PORT = 6379;

    public RedisStore() {
        String str = ConfigManager.getConfiguration((String)"cache-connect", (String)"cache.cluster.0.server");
        String ip = str.split(":")[0];
        int port = NumberUtils.toInt((String)str.split(":")[1], (int)DEFAULT_PORT);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(NumberUtils.toInt((String)ConfigManager.getConfiguration((String)"cache-connect", (String)"cache.cluster.0.connection-pool-size"), (int)10));
        config.setMinIdle(NumberUtils.toInt((String)ConfigManager.getConfiguration((String)"cache-connect", (String)"cache.cluster.0.connection-min-idle"), (int)2));
        config.setMaxIdle(NumberUtils.toInt((String)ConfigManager.getConfiguration((String)"cache-connect", (String)"cache.cluster.0.connection-max-idle"), (int)5));
        this.jedisPool = new JedisPool(config, ip, port, 0, ConfigManager.getConfiguration((String)"cache-connect", (String)"cache.cluster.0.auth"));
    }

    private Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    private void returnJedis(Jedis jedis) {
        if (jedis != null) {
            this.jedisPool.returnResource(jedis);
        }
    }

    private void returnBrokenJedis(Jedis jedis) {
        this.jedisPool.returnBrokenResource(jedis);
    }

    @Override
    public boolean set(String key, String value) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.set(key, value);
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    @Override
    public boolean set(String key, String value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.set(key, value);
    }

    @Override
    public boolean set(String key, String value, long exp) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.setex(key, (int)(exp / 1000L), value);
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    @Override
    public boolean set(String key, String value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.set(key, value, exp);
    }

    @Override
    public String get(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public String get(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.get(key);
    }

    @Override
    public boolean remove(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.del(key);
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
        return true;
    }

    @Override
    public boolean remove(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.remove(key);
    }

    @Override
    public boolean setObject(String key, Object value) throws DataLoadException {
        if (value instanceof CharSequence) {
            return this.set(key, value.toString());
        }
        JsonDto dto = new JsonDto(value);
        return this.set(key, dto.getJson());
    }

    @Override
    public boolean setObject(String key, Object value, long exp) throws DataLoadException {
        if (value instanceof CharSequence) {
            return this.set(key, value.toString(), exp);
        }
        JsonDto dto = new JsonDto(value);
        return this.set(key, dto.getJson(), exp);
    }

    @Override
    public boolean setObject(String key, Object value, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.setObject(key, value);
    }

    @Override
    public boolean setObject(String key, Object value, long exp, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.setObject(key, value, exp);
    }

    @Override
    public Object getObject(String key) throws DataLoadException {
        String jsonstr = this.get(key);
        if (StringUtils.isEmpty((String)jsonstr)) {
            return null;
        }
        JsonDto dto = JsonDto.toJsonDto(jsonstr);
        return dto.getObject();
    }

    @Override
    public Object getObject(String key, CacheConstants.DATA_TYPE type) throws DataLoadException {
        return this.getObject(key);
    }

    @Override
    public Boolean exsit(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public void rename(String key, String newKey) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.rename(key, newKey);
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Set<String> keys(String pattern) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Set set = jedis.keys(pattern);
            return set;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Long ttl(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.ttl(key);
            return l;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public void setObjectForGeneric(String key, Object value) throws DataLoadException {
        if (value instanceof CharSequence) {
            this.set(key, value.toString());
        } else {
            this.set(key, JSON.toJSONString((Object)value));
        }
    }

    @Override
    public void setObjectForGeneric(String key, Object value, long exp) throws DataLoadException {
        if (value instanceof CharSequence) {
            this.set(key, value.toString(), exp);
        } else {
            this.set(key, JSON.toJSONString((Object)value), exp);
        }
    }

    @Override
    public <T> T getObjectForGeneric(String key, Class<T> clazz) throws DataLoadException {
        String jsonstr = this.get(key);
        if (StringUtils.isEmpty((String)jsonstr)) {
            return null;
        }
        return (T)JSON.parseObject((String)jsonstr, clazz);
    }

    @Override
    public <T> List<T> getList(String key, Class<T> clazz) throws DataLoadException {
        String jsonstr = this.get(key);
        if (StringUtils.isEmpty((String)jsonstr)) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)jsonstr, clazz);
    }

    @Override
    public <T> Set<T> getSet(String key, Class<T> clazz) throws DataLoadException {
        List<T> list = this.getList(key, clazz);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptySet();
        }
        HashSet<T> set = new HashSet<T>();
        set.addAll(list);
        return set;
    }

    @Override
    public <T> void rpush(String key, T ... values) throws DataLoadException {
        if (values == null || values.length == 0) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            for (T t : values) {
                if (t instanceof CharSequence) {
                    jedis.rpush(key, (String[])values);
                    break;
                }
                jedis.rpush(key, new String[]{JSON.toJSONString(t)});
            }
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> void lpush(String key, T ... values) throws DataLoadException {
        if (values == null || values.length == 0) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            for (T t : values) {
                if (t instanceof CharSequence) {
                    jedis.lpush(key, (String[])values);
                    break;
                }
                jedis.lpush(key, new String[]{JSON.toJSONString(t)});
            }
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Long llen(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.llen(key);
            return l;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public void lset(String key, long index, Object value) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            if (value instanceof CharSequence) {
                jedis.lset(key, index, (String)value);
            } else {
                jedis.lset(key, index, JSON.toJSONString((Object)value));
            }
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> T lindex(String key, Class<T> clazz, long index) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            if (clazz == String.class) {
                String string = jedis.lindex(key, index);
                return (T)string;
            }
            String str = jedis.lindex(key, index);
            Object object = JSON.parseObject((String)str, clazz);
            return (T)object;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public void ltrim(String key, long start, long end) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.ltrim(key, start, end);
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> T lpop(String key, Class<T> clazz) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            if (clazz == String.class) {
                String string = jedis.lpop(key);
                return (T)string;
            }
            String str = jedis.lpop(key);
            Object object = JSON.parseObject((String)str, clazz);
            return (T)object;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> T rpop(String key, Class<T> clazz) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            if (clazz == String.class) {
                String string = jedis.rpop(key);
                return (T)string;
            }
            String str = jedis.rpop(key);
            Object object = JSON.parseObject((String)str, clazz);
            return (T)object;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> List<T> lrange(String key, Class<T> clazz, int start, int end) throws DataLoadException {
        List list = null;
        ArrayList<Object> result = null;
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            list = jedis.lrange(key, (long)start, (long)end);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                if (clazz == String.class) {
                    List list2 = list;
                    return list2;
                }
                result = new ArrayList<Object>();
                for (String str : list) {
                    result.add(JSON.parseObject((String)str, clazz));
                }
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> void sadd(String key, T ... values) throws DataLoadException {
        if (values == null || values.length == 0) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            for (T t : values) {
                if (t instanceof CharSequence) {
                    jedis.sadd(key, (String[])values);
                    break;
                }
                jedis.sadd(key, new String[]{JSON.toJSONString(t)});
            }
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> void srem(String key, T value) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            if (value instanceof CharSequence) {
                jedis.srem(key, new String[]{(String)value});
            } else {
                jedis.srem(key, new String[]{JSON.toJSONString(value)});
            }
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> Boolean sismember(String key, T value) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            if (value instanceof CharSequence) {
                Boolean bl = jedis.sismember(key, (String)value);
                return bl;
            }
            Boolean bl = jedis.sismember(key, JSON.toJSONString(value));
            return bl;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> Long scard(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.scard(key);
            return l;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> T spop(String key, Class<T> clazz) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            String str = jedis.spop(key);
            if (clazz == String.class) {
                String string = str;
                return (T)string;
            }
            Object object = JSON.parseObject((String)str, clazz);
            return (T)object;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> Set<T> smembers(String key, Class<T> clazz) throws DataLoadException {
        Set set = null;
        HashSet<Object> result = null;
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            set = jedis.smembers(key);
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                if (clazz == String.class) {
                    Set set2 = set;
                    return set2;
                }
                result = new HashSet<Object>();
                for (String str : set) {
                    result.add(JSON.parseObject((String)str, clazz));
                }
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> Set<T> sinter(Class<T> clazz, String ... keys) throws DataLoadException {
        Set set = null;
        HashSet<Object> result = null;
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            set = jedis.sinter(keys);
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                if (clazz == String.class) {
                    Set set2 = set;
                    return set2;
                }
                result = new HashSet<Object>();
                for (String str : set) {
                    result.add(JSON.parseObject((String)str, clazz));
                }
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> Set<T> sunion(Class<T> clazz, String ... keys) throws DataLoadException {
        Set set = null;
        HashSet<Object> result = null;
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            set = jedis.sunion(keys);
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                if (clazz == String.class) {
                    Set set2 = set;
                    return set2;
                }
                result = new HashSet<Object>();
                for (String str : set) {
                    result.add(JSON.parseObject((String)str, clazz));
                }
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> Set<T> sdiff(Class<T> clazz, String ... keys) throws DataLoadException {
        Set set = null;
        HashSet<Object> result = null;
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            set = jedis.sdiff(keys);
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                if (clazz == String.class) {
                    Set set2 = set;
                    return set2;
                }
                result = new HashSet<Object>();
                for (String str : set) {
                    result.add(JSON.parseObject((String)str, clazz));
                }
            }
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> void hset(String key, String field, T value) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            if (value instanceof CharSequence) {
                jedis.hset(key, field, (String)value);
            } else {
                jedis.hset(key, field, JSON.toJSONString(value));
            }
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> void hmset(String key, Map<String, T> map) throws DataLoadException {
        if (map == null || map.size() == 0) {
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            HashMap<String, String> jsonMap = null;
            for (Map.Entry<String, T> entry : map.entrySet()) {
                T value = entry.getValue();
                if (value instanceof CharSequence) {
                    jedis.hmset(key, map);
                    break;
                }
                if (jsonMap == null) {
                    jsonMap = new HashMap<String, String>();
                }
                jsonMap.put(entry.getKey(), JSON.toJSONString(value));
            }
            if (jsonMap != null) {
                jedis.hmset(key, jsonMap);
            }
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> T hget(String key, Class<T> clazz, String field) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            String value = jedis.hget(key, field);
            if (value == null) {
                T t = null;
                return t;
            }
            if (clazz == String.class) {
                String string = value;
                return (T)string;
            }
            Object object = JSON.parseObject((String)value, clazz);
            return (T)object;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> List<T> hmget(String key, Class<T> clazz, String ... fields) throws DataLoadException {
        if (fields == null || fields.length == 0) {
            return Collections.emptyList();
        }
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            List list = jedis.hmget(key, fields);
            if (CollectionUtils.isEmpty((Collection)list)) {
                List list2 = Collections.emptyList();
                return list2;
            }
            if (clazz == String.class) {
                List list3 = list;
                return list3;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (String str : list) {
                result.add(JSON.parseObject((String)str, clazz));
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Long hlen(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Long l = jedis.hlen(key);
            return l;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public Set<String> hkeys(String key) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Set set = jedis.hkeys(key);
            return set;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> List<T> hvals(String key, Class<T> clazz) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            List list = jedis.hvals(key);
            if (CollectionUtils.isEmpty((Collection)list)) {
                List list2 = Collections.emptyList();
                return list2;
            }
            if (clazz == String.class) {
                List list3 = list;
                return list3;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (String str : list) {
                result.add(JSON.parseObject((String)str, clazz));
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }

    @Override
    public <T> Map<String, T> hgetAll(String key, Class<T> clazz) throws DataLoadException {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            Map map = jedis.hgetAll(key);
            if (CollectionUtils.isEmpty((Map)map)) {
                Map map2 = Collections.emptyMap();
                return map2;
            }
            if (clazz == String.class) {
                Map map3 = map;
                return map3;
            }
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                result.put(entry.getKey(), JSON.parseObject((String)key, clazz));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            this.returnBrokenJedis(jedis);
            throw new DataLoadException(e);
        }
        finally {
            this.returnJedis(jedis);
        }
    }
}

