/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.cache.manager.serialize;

import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.DateFormatUtils;
import com.ivms6.core.util.PropertyUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.exception.DateFormatErrorException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSerializer {
    private static Logger log = LoggerFactory.getLogger(XmlSerializer.class);
    private static final String[] SIMPLE_TYPE_NAMES = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.Long", "java.lang.Boolean", "java.util.Date", "java.lang.Double", "java.lang.Short", "java.lang.Float", "java.lang.Byte", "java.util.Calendar", "java.lang.Character"};
    private static final String[] SIMPLE_TYPES = new String[]{"int", "char", "long", "float", "boolean", "byte"};

    public String serialize(Object o) {
        if (o == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<row class=\"");
        Class<?> clazz = o.getClass();
        String className = clazz.getName();
        sb.append(className).append("\"");
        Map map = PropertyUtils.getPropertiesMap((Object)o);
        if (CollectionUtils.isEmpty((Map)map)) {
            return null;
        }
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            String propertyClass;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || !XmlSerializer.isSimpleProperty(propertyClass = value.getClass().getName())) continue;
            this.appendProperty(sb, key, propertyClass, value);
        }
        sb.append("/>");
        return sb.toString();
    }

    private static boolean isSimpleProperty(String clazzName) {
        if (StringUtils.isEmpty((String)clazzName)) {
            return false;
        }
        for (int i = 0; i < SIMPLE_TYPE_NAMES.length; ++i) {
            if (!SIMPLE_TYPE_NAMES[i].equals(clazzName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSimpleType(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return false;
        }
        for (int i = 0; i < SIMPLE_TYPES.length; ++i) {
            if (!SIMPLE_TYPES[i].equals(type)) continue;
            return true;
        }
        return false;
    }

    private void appendProperty(StringBuilder sb, String name, String propertyClass, Object value) {
        String strValue = "";
        strValue = "java.util.Calendar".equals(propertyClass) ? DateFormatUtils.defaultFormat((Calendar)((Calendar)value)) : ("java.util.Date".equals(propertyClass) ? DateFormatUtils.defaultFormat((Date)((Date)value)) : value.toString());
        sb.append(" ").append(name).append("=\"");
        for (int i = 0; i < strValue.length(); ++i) {
            String quote = this.quoteCharCode(strValue.charAt(i));
            if (quote == null) {
                sb.append(strValue.charAt(i));
                continue;
            }
            sb.append(quote);
        }
        sb.append("\"");
    }

    private String quoteCharCode(int code) {
        switch (code) {
            case 38: {
                return "&amp;";
            }
            case 60: {
                return "&lt;";
            }
            case 62: {
                return "&gt;";
            }
            case 34: {
                return "&quot;";
            }
            case 39: {
                return "&apos;";
            }
            case 13: {
                return "&#13;";
            }
        }
        return null;
    }

    public Object unSerialize(String xml) {
        PropertyDescriptor[] descs;
        if (StringUtils.isEmpty((String)xml)) {
            return null;
        }
        Map<String, String> propertyMap = this.parseXml(xml);
        String className = propertyMap.get("class");
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        Object bean = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            bean = clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        for (PropertyDescriptor desc : descs = PropertyUtils.getPropertyDescriptors(clazz)) {
            this.putPropertyValue(propertyMap, bean, desc);
        }
        return bean;
    }

    private void putPropertyValue(Map<String, String> propertyMap, Object bean, PropertyDescriptor desc) {
        if (desc.getName().equals("class")) {
            return;
        }
        Comparable<Calendar> param = null;
        String value = propertyMap.get(desc.getName());
        if (value == null) {
            return;
        }
        try {
            String type = desc.getPropertyType().getName();
            param = type.equals("java.util.Calendar") ? DateFormatUtils.toCalendar((String)value) : (type.equals("java.util.Date") ? DateFormatUtils.toDate((String)value) : (XmlSerializer.isSimpleType(type) ? Class.forName(this.findSimpleClassName(type)).getConstructor(String.class).newInstance(value) : desc.getPropertyType().getConstructor(String.class).newInstance(value)));
            Method writer = desc.getWriteMethod();
            if (writer != null) {
                writer.invoke(bean, param);
            }
        }
        catch (DateFormatErrorException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (SecurityException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("put Property error,", (Throwable)e);
        }
        catch (Exception e) {
            log.error("put Property error,", (Throwable)e);
        }
    }

    private Map<String, String> parseXml(String xml) {
        if (!xml.startsWith("<row")) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        StringBuilder quoteSb = new StringBuilder();
        boolean fieldStart = true;
        boolean valueStart = false;
        boolean quoteStart = false;
        String field = "";
        block7: for (int index = 4; index < xml.length() - 2; ++index) {
            char nextChar = xml.charAt(index);
            switch (nextChar) {
                case '&': {
                    quoteStart = true;
                    quoteSb.append(nextChar);
                    continue block7;
                }
                case ';': {
                    if (quoteStart) {
                        quoteSb.append(nextChar);
                        nextChar = this.charToQuote(quoteSb.toString());
                        quoteSb.delete(0, quoteSb.length());
                        quoteStart = false;
                    }
                    sb.append(nextChar);
                    continue block7;
                }
                case ' ': {
                    if (fieldStart) continue block7;
                    if (!valueStart) {
                        fieldStart = true;
                        continue block7;
                    }
                    sb.append(nextChar);
                    continue block7;
                }
                case '=': {
                    if (!valueStart) {
                        fieldStart = false;
                        field = sb.toString();
                        sb.delete(0, sb.length());
                        continue block7;
                    }
                    sb.append(nextChar);
                    continue block7;
                }
                case '\"': {
                    if (valueStart) {
                        result.put(field, sb.toString());
                        sb.delete(0, sb.length());
                        valueStart = false;
                        continue block7;
                    }
                    valueStart = true;
                    continue block7;
                }
                default: {
                    if (quoteStart) {
                        quoteSb.append(nextChar);
                        continue block7;
                    }
                    sb.append(nextChar);
                }
            }
        }
        return result;
    }

    private char charToQuote(String str) {
        if ("&amp;".equals(str)) {
            return '&';
        }
        if ("&lt;".equals(str)) {
            return '<';
        }
        if ("&gt;".equals(str)) {
            return '>';
        }
        if ("&quot;".equals(str)) {
            return '\"';
        }
        if ("&apos;".equals(str)) {
            return '\'';
        }
        if ("&#13;".equals(str)) {
            return '\r';
        }
        return ' ';
    }

    private String findSimpleClassName(String type) {
        return "java.lang." + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }
}

