/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import com.ivms6.core.util.exception.FatalBeanException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanUtils
extends org.apache.commons.beanutils.BeanUtils {
    public static void copyNotNullProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map map = BeanUtils.describe((Object)orig);
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null || "class".equals(name) || !PropertyUtils.isReadable((Object)orig, (String)name) || !PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
            try {
                Object value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
                BeanUtils.copyProperty((Object)dest, (String)name, (Object)value);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static void copyProperties(Object source, Object target, String[] ignoreProperties) {
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = PropertyUtils.getPropertyDescriptors(actualEditable);
        PropertyDescriptor[] sourcePds = PropertyUtils.getPropertyDescriptors(source.getClass());
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        int i = 0;
        while (i < targetPds.length) {
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = targetPds[i];
            if (!(targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.findPropertyDescriptor(sourcePds, targetPd.getName())) == null || sourcePd.getReadMethod() == null)) {
                try {
                    Method readMethod = sourcePd.getReadMethod();
                    if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                        readMethod.setAccessible(true);
                    }
                    Object value = readMethod.invoke(source, new Object[0]);
                    Method writeMethod = targetPd.getWriteMethod();
                    if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                        writeMethod.setAccessible(true);
                    }
                    writeMethod.invoke(target, value);
                }
                catch (Throwable ex) {
                    throw new FatalBeanException("Could not copy properties from source to target", ex);
                }
            }
            ++i;
        }
    }

    private static PropertyDescriptor findPropertyDescriptor(PropertyDescriptor[] sourcePds, String name) {
        if (sourcePds == null || sourcePds.length < 1) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = sourcePds;
        int n = sourcePds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getName().equals(name)) {
                return pd;
            }
            ++n2;
        }
        return null;
    }
}

