/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ClassLoaderUtil {
    public static ClassLoader getClassLoader() {
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static InputStream getStream(String relativePath) throws MalformedURLException, IOException {
        if (!relativePath.contains("../")) {
            return ClassLoaderUtil.getClassLoader().getResourceAsStream(relativePath);
        }
        return ClassLoaderUtil.getStreamByExtendResource(relativePath);
    }

    public static InputStream getStream(URL url) throws IOException {
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static InputStream getStreamByExtendResource(String relativePath) throws MalformedURLException, IOException {
        return ClassLoaderUtil.getStream(ClassLoaderUtil.getResource(relativePath));
    }

    public static Properties getProperties(String resource) {
        Properties properties = new Properties();
        try {
            properties.load(ClassLoaderUtil.getStream(resource));
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't load properties file '" + resource + "'", e);
        }
        return properties;
    }

    public static String getAbsoluteClassPath() {
        String path = "";
        URL url = ClassLoaderUtil.class.getProtectionDomain().getCodeSource().getLocation();
        if (url != null) {
            path = "file:" + url.getPath().substring(0, url.getPath().lastIndexOf("/"));
        }
        return path;
    }

    public static URL getResource(String relativePath) throws MalformedURLException {
        if (!relativePath.contains("../")) {
            return ClassLoaderUtil.getClassLoader().getResource(relativePath);
        }
        String classPathAbsolutePath = ClassLoaderUtil.getAbsoluteClassPath();
        URL resourceAbsoluteURL = new URL(String.valueOf(classPathAbsolutePath) + relativePath.substring(2));
        return resourceAbsoluteURL;
    }
}

