/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    private static Integer MAX_SIZE_IN_CLAUSE = 500;

    public static String merge(Collection<?> collection, String stoken) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        stoken = stoken == null ? "," : stoken;
        for (Object candidate : collection) {
            sb.append(candidate).append(stoken);
        }
        sb.delete(sb.length() - stoken.length(), sb.length());
        return sb.toString();
    }

    public static String merge(Object[] objs, String stoken) {
        if (objs == null || objs.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        stoken = stoken == null ? "," : stoken;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object candidate = objectArray[n2];
            sb.append(candidate).append(stoken);
            ++n2;
        }
        sb.delete(sb.length() - stoken.length(), sb.length());
        return sb.toString();
    }

    public static String merge(Collection<?> collection) {
        return CollectionUtils.merge(collection, ",");
    }

    public static List<String> toList(String str, String stoken) {
        if (str == null || str.trim().length() < 1) {
            return null;
        }
        stoken = stoken == null ? "," : stoken;
        String[] array = str.split(stoken);
        return Arrays.asList(array);
    }

    public static List<String> toList(String str) {
        return CollectionUtils.toList(str, ",");
    }

    public static List<Integer> toIntList(String str, String stoken) {
        if (str == null || str.trim().length() < 1) {
            return null;
        }
        stoken = stoken == null ? "," : stoken;
        String[] array = str.split(stoken);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            try {
                Integer temp = Integer.valueOf(array[i].trim());
                result.add(temp);
            }
            catch (NumberFormatException e) {
                result.add(0);
            }
            ++i;
        }
        return result;
    }

    public static List<Integer> toIntList(String str) {
        return CollectionUtils.toIntList(str, ",");
    }

    public static List<Long> toLongList(String str, String stoken) {
        if (str == null || str.trim().length() < 1) {
            return null;
        }
        stoken = stoken == null ? "," : stoken;
        String[] array = str.split(stoken);
        ArrayList<Long> result = new ArrayList<Long>();
        int i = 0;
        while (i < array.length) {
            try {
                Long temp = Long.valueOf(array[i].trim());
                result.add(temp);
            }
            catch (NumberFormatException e) {
                result.add(0L);
            }
            ++i;
        }
        return result;
    }

    public static List<Long> toLongList(String str) {
        return CollectionUtils.toLongList(str, ",");
    }

    public static String[] toStringArray(Collection<?> col) {
        if (CollectionUtils.isEmpty(col)) {
            return new String[0];
        }
        String[] result = new String[col.size()];
        int i = 0;
        for (Object o : col) {
            result[i++] = o == null ? "" : o.toString();
        }
        return result;
    }

    public static long[] toLongArray(Collection<Long> col) {
        if (CollectionUtils.isEmpty(col)) {
            return new long[0];
        }
        long[] result = new long[col.size()];
        int i = 0;
        for (Long o : col) {
            result[i++] = o == null ? 0L : o;
        }
        return result;
    }

    public static Long[] toLongObjArray(Collection<Long> col) {
        if (CollectionUtils.isEmpty(col)) {
            return new Long[0];
        }
        Long[] result = new Long[col.size()];
        int i = 0;
        for (Long o : col) {
            result[i++] = o;
        }
        return result;
    }

    public static List<Object> toList(Object[] col) {
        if (col == null) {
            return null;
        }
        if (col.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> l = new ArrayList<Object>();
        Object[] objectArray = col;
        int n = col.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            l.add(o);
            ++n2;
        }
        return l;
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static <T> List<List<T>> convertListToList(Collection<T> list) {
        return CollectionUtils.convertListToList(list, MAX_SIZE_IN_CLAUSE);
    }

    public static <T> List<List<T>> convertListToList(Collection<T> list, int size) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> ids = null;
        int index = 0;
        for (T id : list) {
            if (index++ % size == 0) {
                ids = new ArrayList<T>();
                result.add(ids);
            }
            ids.add(id);
        }
        return result;
    }
}

