/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.exception.DateFormatErrorException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class DateFormatUtils {
    public static final String FORMAT_COMMON_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_LONG = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_SHORT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DATE_FORMAT_NUM_LONG = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT_NUM_SHORT = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_MIN = "yyyy-MM-dd";
    private static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final FastDateFormat ISO_DATETIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss");
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZZ");
    public static final FastDateFormat ISO_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    public static final FastDateFormat ISO_DATE_TIME_ZONE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-ddZZ");
    public static final FastDateFormat ISO_TIME_FORMAT = FastDateFormat.getInstance((String)"'T'HH:mm:ss");
    public static final FastDateFormat ISO_TIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance((String)"'T'HH:mm:ssZZ");
    public static final FastDateFormat ISO_TIME_NO_T_FORMAT = FastDateFormat.getInstance((String)"HH:mm:ss");
    public static final FastDateFormat ISO_TIME_NO_T_TIME_ZONE_FORMAT = FastDateFormat.getInstance((String)"HH:mm:ssZZ");
    public static final FastDateFormat SMTP_DATETIME_FORMAT = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss Z", (Locale)Locale.US);

    public static String formatUTC(long millis, String pattern) {
        return DateFormatUtils.format(new Date(millis), pattern, DateUtils.UTC_TIME_ZONE, null);
    }

    public static String formatUTC(Date date, String pattern) {
        return DateFormatUtils.format(date, pattern, DateUtils.UTC_TIME_ZONE, null);
    }

    public static String formatUTC(long millis, String pattern, Locale locale) {
        return DateFormatUtils.format(new Date(millis), pattern, DateUtils.UTC_TIME_ZONE, locale);
    }

    public static String formatUTC(Date date, String pattern, Locale locale) {
        return DateFormatUtils.format(date, pattern, DateUtils.UTC_TIME_ZONE, locale);
    }

    public static String format(long millis, String pattern) {
        return DateFormatUtils.format(new Date(millis), pattern, null, null);
    }

    public static String format(Date date, String pattern) {
        return DateFormatUtils.format(date, pattern, null, null);
    }

    public static String format(Calendar calendar, String pattern) {
        return DateFormatUtils.format(calendar, pattern, null, null);
    }

    public static String format(long millis, String pattern, TimeZone timeZone) {
        return DateFormatUtils.format(new Date(millis), pattern, timeZone, null);
    }

    public static String format(Date date, String pattern, TimeZone timeZone) {
        return DateFormatUtils.format(date, pattern, timeZone, null);
    }

    public static String format(Calendar calendar, String pattern, TimeZone timeZone) {
        return DateFormatUtils.format(calendar, pattern, timeZone, null);
    }

    public static String format(long millis, String pattern, Locale locale) {
        return DateFormatUtils.format(new Date(millis), pattern, null, locale);
    }

    public static String format(Date date, String pattern, Locale locale) {
        return DateFormatUtils.format(date, pattern, null, locale);
    }

    public static String format(Calendar calendar, String pattern, Locale locale) {
        return DateFormatUtils.format(calendar, pattern, null, locale);
    }

    public static String format(long millis, String pattern, TimeZone timeZone, Locale locale) {
        return DateFormatUtils.format(new Date(millis), pattern, timeZone, locale);
    }

    public static String format(Date date, String pattern, TimeZone timeZone, Locale locale) {
        FastDateFormat df = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
        return df.format(date);
    }

    public static String format(Calendar calendar, String pattern, TimeZone timeZone, Locale locale) {
        FastDateFormat df = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
        return df.format(calendar);
    }

    public static String getDefaultCurrentDate() {
        return DateFormatUtils.getCurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static String getCurrentDateFormat(String format) {
        return DateFormatUtils.format(Calendar.getInstance(), format);
    }

    public static String defaultFormat(Date date) {
        return DateFormatUtils.format(date, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static String defaultFormat(Calendar calendar) {
        return DateFormatUtils.format(calendar, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static String defaultFormat(long timeInMillis) {
        return DateFormatUtils.format(timeInMillis, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static String format(String dateStr, String srcFormat, String dstFormat) throws DateFormatErrorException {
        if (StringUtils.isEmpty((String)dateStr) || StringUtils.isEmpty((String)srcFormat) || StringUtils.isEmpty((String)dstFormat)) {
            return null;
        }
        Calendar cal = DateFormatUtils.toCalendar(dateStr, srcFormat);
        return DateFormatUtils.format(cal, dstFormat);
    }

    public static Calendar toCalendar(String dateString) throws DateFormatErrorException {
        return DateFormatUtils.toCalendar(dateString, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static Calendar toCalendar(String dateStr, String format) throws DateFormatErrorException {
        if (StringUtils.isEmpty((String)dateStr) || StringUtils.isEmpty((String)format)) {
            return null;
        }
        Date date = DateFormatUtils.toDate(dateStr, format);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(long timeInMillis) {
        if (timeInMillis < 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return calendar;
    }

    public static Calendar toCalendar(int year, int month, int date, int hourOfDay, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date, hourOfDay, minute, second);
        return calendar;
    }

    public static long getTimeInMillis(String dateStr) throws DateFormatErrorException {
        return DateFormatUtils.getTimeInMillis(dateStr, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static long getTimeInMillis(String dateStr, String format) throws DateFormatErrorException {
        if (StringUtils.isEmpty((String)dateStr) || StringUtils.isEmpty((String)format)) {
            return -1L;
        }
        Calendar calendar = DateFormatUtils.toCalendar(dateStr, format);
        return calendar.getTimeInMillis();
    }

    public static Calendar getWholeHour() {
        return DateFormatUtils.getWholeHour(Calendar.getInstance(), -1);
    }

    public static Calendar getWholeHour(int hour) {
        return DateFormatUtils.getWholeHour(Calendar.getInstance(), hour);
    }

    public static Calendar getWholeHour(Calendar calendar, int hour) {
        if (calendar == null) {
            return null;
        }
        calendar.clear(13);
        calendar.clear(12);
        calendar.clear(14);
        calendar.clear(11);
        if (hour >= 0) {
            calendar.set(11, hour);
        }
        return calendar;
    }

    public static Calendar afterDays(long days) {
        return DateFormatUtils.afterMilliseconds(Calendar.getInstance(), days * 24L * 3600L * 1000L);
    }

    public static Calendar afterDays(Calendar calendar, long days) {
        return DateFormatUtils.afterMilliseconds(calendar, days * 24L * 3600L * 1000L);
    }

    public static Calendar afterHours(long hours) {
        return DateFormatUtils.afterMilliseconds(Calendar.getInstance(), hours * 3600L * 1000L);
    }

    public static Calendar afterHours(Calendar calendar, long hours) {
        return DateFormatUtils.afterMilliseconds(calendar, hours * 3600L * 1000L);
    }

    public static Calendar afterMinutes(long minutes) {
        return DateFormatUtils.afterMilliseconds(Calendar.getInstance(), minutes * 60L * 1000L);
    }

    public static Calendar afterMinutes(Calendar calendar, long minutes) {
        return DateFormatUtils.afterMilliseconds(calendar, minutes * 60L * 1000L);
    }

    public static Calendar afterSeconds(long seconds) {
        return DateFormatUtils.afterMilliseconds(Calendar.getInstance(), seconds * 1000L);
    }

    public static Calendar afterSeconds(Calendar calendar, long seconds) {
        return DateFormatUtils.afterMilliseconds(calendar, seconds * 1000L);
    }

    public static Calendar afterMilliseconds(long milliseconds) {
        return DateFormatUtils.afterMilliseconds(Calendar.getInstance(), milliseconds);
    }

    public static Calendar afterMilliseconds(Calendar calendar, long milliseconds) {
        if (calendar == null) {
            return null;
        }
        calendar.setTimeInMillis(calendar.getTimeInMillis() + milliseconds);
        return calendar;
    }

    public static Calendar afterYears(int years) {
        return DateFormatUtils.afterYears(Calendar.getInstance(), years);
    }

    public static Calendar afterYears(Calendar calendar, int years) {
        if (calendar == null) {
            return null;
        }
        calendar.add(1, years);
        return calendar;
    }

    public static Calendar afterMonths(int months) {
        return DateFormatUtils.afterMonths(Calendar.getInstance(), months);
    }

    public static Calendar afterMonths(Calendar calendar, int months) {
        if (calendar == null) {
            return null;
        }
        calendar.add(2, months);
        return calendar;
    }

    public static Calendar getZeroTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static long getZeroTimeInMillis() {
        return DateFormatUtils.getZeroTime().getTimeInMillis();
    }

    public static Date toDate(String dateStr) throws DateFormatErrorException {
        return DateFormatUtils.toDate(dateStr, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static Date toDate(String dateStr, String format) throws DateFormatErrorException {
        if (StringUtils.isEmpty((String)dateStr) || StringUtils.isEmpty((String)format)) {
            return null;
        }
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            date = dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new DateFormatErrorException("date string [" + dateStr + "] is a wrong format for [" + format + "]", e);
        }
        return date;
    }

    public static Date toDate(long timeInMillis) {
        if (timeInMillis < 1L) {
            return null;
        }
        return new Date(timeInMillis);
    }
}

