/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import com.ivms6.core.util.ResourceUtils;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    protected static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static File loadFromClassPath(String path) {
        log.debug("Opening resource from class path [{}]", (Object)path);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(path);
        if (url == null) {
            log.trace("Resource [{}] was not found via the thread context ClassLoader.   Trying the current ClassLoader...", (Object)path);
            loader = ResourceUtils.class.getClassLoader();
            url = loader.getResource(path);
        }
        if (url == null) {
            log.trace("Resource [{}] was not found via the current class loader.  Trying the system/application ClassLoader...", (Object)path);
            loader = ClassLoader.getSystemClassLoader();
            url = loader.getResource(path);
        }
        if (url == null) {
            log.trace("Resource [{}] was not found via the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Returning null.", (Object)path);
            return null;
        }
        File result = FileUtils.toFile((URL)url);
        return result;
    }
}

