/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericsUtil {
    private static final Logger log = LoggerFactory.getLogger(GenericsUtil.class);

    public static boolean isSuperClassHasGenricType(Class<?> clazz) {
        Type genType = clazz.getGenericSuperclass();
        return genType instanceof ParameterizedType;
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz) {
        return GenericsUtil.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn(String.valueOf(clazz.getSimpleName()) + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn(String.valueOf(clazz.getSimpleName()) + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static boolean isImplements(Class<?> c, String szInterface) {
        Class<?>[] face = c.getInterfaces();
        int i = 0;
        int j = face.length;
        while (i < j) {
            if (face[i].getName().equals(szInterface)) {
                return true;
            }
            Class<?>[] face1 = face[i].getInterfaces();
            int x = 0;
            while (x < face1.length) {
                if (face1[x].getName().equals(szInterface)) {
                    return true;
                }
                if (GenericsUtil.isImplements(face1[x], szInterface)) {
                    return true;
                }
                ++x;
            }
            ++i;
        }
        if (c.getSuperclass() != null) {
            return GenericsUtil.isImplements(c.getSuperclass(), szInterface);
        }
        return false;
    }
}

