/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import com.ivms6.core.util.BeanUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeUtils {
    private static Logger log = LoggerFactory.getLogger(BeanUtils.class);

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        return InvokeUtils.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class<?> clazz, String propertyName) throws NoSuchFieldException {
        Class<?> superClass = clazz;
        try {
            return superClass.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException localNoSuchFieldException) {
            superClass = superClass.getSuperclass();
            if (superClass != Object.class) {
                return InvokeUtils.getDeclaredField(superClass, propertyName);
            }
            throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
        }
    }

    public static Object forceGetProperty(Object object, String propertyName) throws NoSuchFieldException {
        Field field = InvokeUtils.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            log.info("error wont' happen");
        }
        field.setAccessible(accessible);
        return result;
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        Field field = InvokeUtils.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            log.info("Error won't happen");
        }
        field.setAccessible(accessible);
    }

    public static Object invoke(Object target, String methodName, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methods;
        Method[] methodArray = methods = target.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName() != null && m.getName().equals(methodName)) {
                boolean accessible = m.isAccessible();
                m.setAccessible(true);
                Object o = m.invoke(target, params);
                m.setAccessible(accessible);
                return o;
            }
            ++n2;
        }
        return null;
    }

    public static Object invoke(Class<?> clazz, String name, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Method[] methods = clazz.getMethods();
        Object bean = clazz.newInstance();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName() != null && m.getName().equals(name)) {
                boolean accessible = m.isAccessible();
                m.setAccessible(true);
                Object o = m.invoke(bean, params);
                m.setAccessible(accessible);
                return o;
            }
            ++n2;
        }
        return null;
    }
}

