/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    static {
        objectMapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public static String object2Json(Object obj) {
        String jsonStr = null;
        try {
            if (obj != null) {
                jsonStr = objectMapper.writeValueAsString(obj);
            }
        }
        catch (JsonGenerationException e) {
            log.warn("Object2JsonStr exception", (Throwable)e);
        }
        catch (JsonMappingException e) {
            log.warn("Object2JsonStr exception", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Object2JsonStr exception", (Throwable)e);
        }
        return jsonStr;
    }

    public static <T> T json2Object(String jsonStr, Class<T> valueType) {
        Object obj = null;
        try {
            if (valueType != null) {
                obj = objectMapper.readValue(jsonStr, valueType);
            }
        }
        catch (JsonParseException e) {
            log.warn("json2Object exception", (Throwable)e);
        }
        catch (JsonMappingException e) {
            log.warn("json2Object exception", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("json2Object exception", (Throwable)e);
        }
        return (T)obj;
    }

    public static <T> T json2Object(String jsonStr, TypeReference<T> typeReference) {
        Object obj = null;
        try {
            if (typeReference != null) {
                obj = objectMapper.readValue(jsonStr, typeReference);
            }
        }
        catch (JsonParseException e) {
            log.warn("json2Object exception", (Throwable)e);
        }
        catch (JsonMappingException e) {
            log.warn("json2Object exception", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("json2Object exception", (Throwable)e);
        }
        return (T)obj;
    }
}

