/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PinyinUtils.class);

    public static String getCharacterPinYin(char c, boolean isShort) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        String[] pinyin = null;
        try {
            pinyin = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            LOG.warn("PinyinHelper.toHanyuPinyinStringArray error", (Throwable)e);
        }
        if (pinyin == null) {
            return null;
        }
        if (!isShort) {
            return pinyin[0];
        }
        return String.valueOf(pinyin[0].charAt(0));
    }

    public static String getStringPinYin(String str, boolean isShort) {
        StringBuilder sb = new StringBuilder();
        String tempPinyin = null;
        int i = 0;
        while (i < str.length()) {
            tempPinyin = PinyinUtils.getCharacterPinYin(str.charAt(i), isShort);
            if (tempPinyin == null) {
                sb.append(str.charAt(i));
            } else {
                sb.append(tempPinyin);
            }
            ++i;
        }
        return sb.toString();
    }
}

