/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import com.ivms6.core.util.IOUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String URL_PREFIX = "url:";
    public static final String FILE_PREFIX = "file:";
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    public static boolean hasResourcePrefix(String resourcePath) {
        return resourcePath != null && (resourcePath.startsWith(CLASSPATH_PREFIX) || resourcePath.startsWith(URL_PREFIX) || resourcePath.startsWith(FILE_PREFIX));
    }

    public static boolean resourceExists(String resourcePath) {
        InputStream stream = null;
        boolean exists = false;
        try {
            try {
                stream = ResourceUtils.getInputStreamForPath(resourcePath);
                exists = true;
            }
            catch (IOException e) {
                stream = null;
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return exists;
    }

    public static InputStream getInputStreamForPath(String resourcePath) throws IOException {
        InputStream is = resourcePath.startsWith(CLASSPATH_PREFIX) ? ResourceUtils.loadFromClassPath(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(URL_PREFIX) ? ResourceUtils.loadFromUrl(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(FILE_PREFIX) ? ResourceUtils.loadFromFile(ResourceUtils.stripPrefix(resourcePath)) : ResourceUtils.loadFromFile(resourcePath)));
        if (is == null) {
            throw new IOException("Resource [" + resourcePath + "] could not be found.");
        }
        return is;
    }

    private static InputStream loadFromFile(String path) throws IOException {
        log.debug("Opening file [{}]...", (Object)path);
        return new FileInputStream(path);
    }

    private static InputStream loadFromUrl(String urlPath) throws IOException {
        log.debug("Opening url {}", (Object)urlPath);
        URL url = new URL(urlPath);
        return url.openStream();
    }

    private static InputStream loadFromClassPath(String path) {
        log.debug("Opening resource from class path [{}]", (Object)path);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream(path);
        log.debug(loader.getClass().getName());
        log.debug("1----is is null:" + is == null ? "true" : "false");
        if (is == null) {
            log.trace("Resource [{}] was not found via the thread context ClassLoader.   Trying the current ClassLoader...", (Object)path);
            loader = ResourceUtils.class.getClassLoader();
            is = loader.getResourceAsStream(path);
            log.debug(loader.getClass().getName());
            log.debug("2----is is null:" + is == null ? "true" : "false");
        }
        if (is == null) {
            log.trace("Resource [{}] was not found via the current class loader.  Trying the system/application ClassLoader...", (Object)path);
            loader = ClassLoader.getSystemClassLoader();
            is = loader.getResourceAsStream(path);
            log.debug(loader.getClass().getName());
            log.debug("2----is is null:" + is == null ? "true" : "false");
        }
        if (is == null) {
            log.trace("Resource [{}] was not found via the thread context, current, or system/application ClassLoaders.  All heuristics have been exhausted.  Returning null.", (Object)path);
        }
        return is;
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(":") + 1);
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn("Error closing input stream.", (Throwable)e);
            }
        }
    }
}

