/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util;

import com.ivms6.core.util.IOUtils;
import com.ivms6.core.util.StringUtils;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLUtils {
    public static final Logger log = Logger.getLogger(XMLUtils.class);
    private static XStream xstream = new XStream();

    public static void createXMLFile(Document doc, String fileName, String encoding) {
        OutputStreamWriter writer = null;
        try {
            try {
                XMLWriter xmlwriter = null;
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "utf-8");
                if (StringUtils.isBlank((String)encoding)) {
                    xmlwriter = new XMLWriter((Writer)writer);
                } else {
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setEncoding(encoding);
                    xmlwriter = new XMLWriter((Writer)writer, format);
                }
                xmlwriter.write(doc);
            }
            catch (IOException e) {
                log.error((Object)"\u521b\u5efaxml\u6587\u4ef6\u9519\u8bef\uff01");
                IOUtils.closeQuietly(writer);
                return;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public static Document createDocument(String rootLabel) {
        Document doc = DocumentHelper.createDocument();
        doc.setRootElement(doc.addElement(rootLabel));
        return doc;
    }

    public static Document createDocumentWithNameSpace(String xml, Map<?, ?> map) {
        SAXReader reader = new SAXReader();
        reader.getDocumentFactory().setXPathNamespaceURIs(map);
        Document document = null;
        try {
            document = reader.read((Reader)new StringReader(xml));
        }
        catch (DocumentException e) {
            log.error((Object)xml);
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
            return null;
        }
        return document;
    }

    public static Document convertStringToXml(String xmlString) throws DocumentException {
        if (StringUtils.isBlank((String)xmlString)) {
            throw new DocumentException("");
        }
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xmlString);
        }
        catch (DocumentException e) {
            log.error((Object)"\u8f6c\u6362xml\u9519\u8bef\uff01");
            throw e;
        }
        return document;
    }

    public static void addNode(Element parentNode, String nodeLabel, String nodeId, Map<?, ?> elements) {
        Element newNode = parentNode.addElement(nodeLabel);
        newNode.addAttribute("id", nodeId);
        for (Map.Entry<?, ?> entry : elements.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            newNode.addElement((String)key).setText((String)value);
        }
    }

    public static void addNodeWithAttribute(Element parentNode, String nodeLabel, String nodeId, Map<?, ?> elements) {
        Element newNode = parentNode.addElement(nodeLabel);
        newNode.addAttribute("id", nodeId);
        for (Map.Entry<?, ?> entry : elements.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            newNode.addAttribute((String)key, (String)value);
        }
        newNode.setText("");
    }

    public static String readXmlAsString(String filePath) {
        SAXReader reader = new SAXReader();
        Document document = null;
        InputStream inputStream = null;
        try {
            try {
                inputStream = XMLUtils.class.getClassLoader().getResourceAsStream(filePath);
                document = reader.read(inputStream);
            }
            catch (DocumentException e) {
                log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
                IOUtils.closeQuietly((InputStream)inputStream);
                return "";
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return document.asXML();
    }

    public static String readXmlAsString(File file) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(file);
        }
        catch (DocumentException e) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
            return "";
        }
        return document.asXML();
    }

    public static String readXmlAsString(InputStream input) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(input);
        }
        catch (DocumentException e) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
            return "";
        }
        return document.asXML();
    }

    public static List<Element> getElementsByXPath(String filePath, String xpath) {
        SAXReader reader = new SAXReader();
        List properties = null;
        InputStream inputStream = null;
        try {
            try {
                inputStream = XMLUtils.class.getClassLoader().getResourceAsStream(filePath);
                XMLUtils.class.getClassLoader().getResourceAsStream(filePath);
                Document doc = reader.read(inputStream);
                properties = doc.selectNodes(xpath);
            }
            catch (Exception ex) {
                log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
                IOUtils.closeQuietly((InputStream)inputStream);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return properties;
    }

    public static List<Element> getElementsByXPath(InputStream input, String xpath) {
        SAXReader reader = new SAXReader();
        List properties = null;
        try {
            Document doc = reader.read(input);
            properties = doc.selectNodes(xpath);
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
            return null;
        }
        return properties;
    }

    public static List<Element> getElementsByXPath(File file, String xpath) {
        SAXReader reader = new SAXReader();
        List properties = null;
        try {
            Document doc = reader.read(file);
            properties = doc.selectNodes(xpath);
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
            return null;
        }
        return properties;
    }

    public static List<Element> getElementsByXPath(Document doc, String xpath) {
        List properties = null;
        try {
            properties = doc.selectNodes(xpath);
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
            return null;
        }
        return properties;
    }

    public static Document getXmlDocment(File file) {
        if (file == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(file);
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
            return null;
        }
        return doc;
    }

    public static Document getXmlDocment(String filePath) {
        if (StringUtils.isBlank((String)filePath)) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = null;
        InputStream inputStream = null;
        try {
            try {
                inputStream = XMLUtils.class.getClassLoader().getResourceAsStream(filePath);
                doc = reader.read(inputStream);
            }
            catch (Exception ex) {
                log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
                IOUtils.closeQuietly((InputStream)inputStream);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return doc;
    }

    public static Document getXmlDocment(InputStream input) {
        if (input == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read((Reader)new InputStreamReader(input, "utf-8"));
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
            return null;
        }
        return doc;
    }

    public static Document getXmlDocment(InputStream input, String charset) {
        if (input == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            if (charset == null || charset.equals("")) {
                charset = "utf-8";
            }
            doc = reader.read((Reader)new InputStreamReader(input, charset));
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6xml\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)ex);
            return null;
        }
        return doc;
    }

    public static String bean2XML(Object bean) {
        return xstream.toXML(bean);
    }

    public static String bean2XML(Object bean, String root) {
        xstream.aliasPackage(root, bean.getClass().getName());
        return xstream.toXML(bean);
    }

    public static <T> String list2XML(List<T> list, Class<T> clazz) {
        return XMLUtils.list2XML(list, clazz, "bean");
    }

    public static <T> String list2XML(List<T> list, Class<T> clazz, String root) {
        Field[] fields;
        xstream.alias(root, list.getClass());
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            xstream.useAttributeFor(clazz, field.getName());
            ++n2;
        }
        xstream.alias(clazz.getSimpleName(), clazz);
        return xstream.toXML(list);
    }

    public static <T> List<T> xml2List(String xml) {
        return (List)xstream.fromXML(xml);
    }

    public static <T> List<T> xml2List(File file) {
        return (List)xstream.fromXML(file);
    }

    public static <T> List<T> xml2List(InputStream is) {
        return (List)xstream.fromXML(is);
    }

    public static <T> List<T> xml2List(Reader reader) {
        return (List)xstream.fromXML(reader);
    }

    public static Object xml2Bean(String xml) {
        return xstream.fromXML(xml);
    }

    public static Object xml2Bean(File file) {
        return xstream.fromXML(file);
    }

    public static Object xml2Bean(InputStream is) {
        return xstream.fromXML(is);
    }

    public static Object xml2Bean(Reader reader) {
        return xstream.fromXML(reader);
    }
}

