/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.bean;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Page
implements Serializable {
    private static final long serialVersionUID = 689412396838419845L;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private int pageNo = 1;
    private int pageSize = 20;
    private List<?> result = null;
    private long total = 0L;
    private static Page emptyPage = new Page();

    public static Page getEmptyPage() {
        return emptyPage;
    }

    public Page() {
    }

    public Page(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public Page(int pageNo, int pageSize, List<?> result, long total) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.result = result;
        this.total = total;
    }

    public int getFirst() {
        if (this.pageNo < 1 || this.pageSize < 1) {
            return 0;
        }
        return (this.pageNo - 1) * this.pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<?> getResult() {
        if (this.result == null) {
            this.result = Collections.emptyList();
        }
        return this.result;
    }

    public long getTotal() {
        return this.total;
    }

    public int getTotalPage() {
        if (this.total == 0L) {
            return 0;
        }
        int count = (int)this.total / this.pageSize;
        if (this.total % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setResult(List<?> result) {
        this.result = result;
    }

    public void setTotal(long total) {
        this.total = total;
    }
}

