/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.cm;

import com.ivms6.core.util.FileUtils;
import com.ivms6.core.util.cm.Configuration;
import com.ivms6.core.util.cm.ConfigurationException;
import com.ivms6.core.util.cm.modify.PropertiesOperator;
import com.ivms6.core.util.cm.modify.PropertyItem;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    protected static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private static Configuration config = new Configuration();

    static {
        try {
            config.loadFromPath("classpath:system.properties");
        }
        catch (Exception e) {
            log.warn("classpath:system.properties loadFromPath error, ", (Throwable)e);
        }
    }

    public static Configuration openPropertiesFile(String path) {
        Configuration dConfig = new Configuration();
        try {
            dConfig.loadFromPath(path);
        }
        catch (Exception e) {
            log.warn("classpath:" + path + " loadFromPath error, ", (Throwable)e);
            return null;
        }
        return dConfig;
    }

    public static boolean reload() throws ConfigurationException {
        config = null;
        config = new Configuration();
        config.loadFromPath("classpath:system.properties");
        log.info("reload configuration,path is '{}'", new Object[]{"classpath:system.properties"});
        return true;
    }

    public static boolean reload(String path) throws ConfigurationException {
        config = null;
        config = new Configuration();
        config.loadFromPath("classpath:" + path);
        log.info("reload configuration,path is 'classpath:{}'", new Object[]{path});
        return true;
    }

    public static String getConfiguration(String sectionName, String propertyName) {
        return config.getSectionProperty(sectionName, propertyName);
    }

    public static void setConfiguration(String sectionName, String propertyName, String propertyValue) {
        config.setSectionProperty(sectionName, propertyName, propertyValue);
    }

    public static void updateConfiguration(String filePath, String sectionName, String propertyName, String propertyValue) {
        File file = ConfigManager.loadFile(filePath);
        if (file == null) {
            return;
        }
        PropertiesOperator op = new PropertiesOperator();
        op.updateProperty(file, sectionName, propertyName, propertyValue);
    }

    private static File loadFile(String filePath) {
        File file = null;
        file = filePath.startsWith("classpath:") ? FileUtils.loadFromClassPath(ConfigManager.stripPrefix(filePath)) : (filePath.startsWith("file:") ? ConfigManager.loadFromFile(ConfigManager.stripPrefix(filePath)) : ConfigManager.loadFromFile(filePath));
        if (file == null || !file.exists()) {
            log.error("file [{}] is not exist.", new Object[]{filePath});
            return null;
        }
        return file;
    }

    public static void updateConfiguration(String filePath, PropertyItem item) {
        File file = ConfigManager.loadFile(filePath);
        if (file == null) {
            return;
        }
        PropertiesOperator op = new PropertiesOperator();
        op.updateProperty(file, item);
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(":") + 1);
    }

    public static void updateConfigurations(String filePath, List<PropertyItem> items) {
        File file = ConfigManager.loadFile(filePath);
        if (file == null) {
            return;
        }
        PropertiesOperator op = new PropertiesOperator();
        op.updateProperty(file, items);
    }

    private static File loadFromFile(String stripPrefix) {
        return new File(stripPrefix);
    }

    public static Map<String, String> getSection(String sectionName) {
        return config.getSection(sectionName);
    }

    public static Configuration getConfig() {
        return config;
    }
}

