/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.cm;

import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.ResourceUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigurationException;
import com.ivms6.core.util.cm.Section;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements Map<String, Section> {
    private static final transient Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_SECTION_NAME = "";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String COMMENT_POUND = "#";
    public static final String COMMENT_SEMICOLON = ";";
    public static final String SECTION_PREFIX = "[";
    public static final String SECTION_SUFFIX = "]";
    protected static final char ESCAPE_TOKEN = '\\';
    private final Map<String, Section> sections = new LinkedHashMap<String, Section>();

    public Configuration() {
    }

    public Configuration(Configuration defaults) {
        this();
        if (defaults == null) {
            throw new NullPointerException("Defaults cannot be null.");
        }
        for (Section section : defaults.getSections()) {
            Section copy = new Section(section);
            this.sections.put(section.getName(), copy);
        }
    }

    @Override
    public boolean isEmpty() {
        Collection<Section> sections = this.sections.values();
        if (!sections.isEmpty()) {
            for (Section section : sections) {
                if (section.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public Set<String> getSectionNames() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    public Section getSection(String sectionName) {
        String name = Configuration.cleanName(sectionName);
        return this.sections.get(name);
    }

    public Section addSection(String sectionName) {
        String name = Configuration.cleanName(sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = new Section(name);
            this.sections.put(name, section);
        }
        return section;
    }

    public Section removeSection(String sectionName) {
        String name = Configuration.cleanName(sectionName);
        return this.sections.remove(name);
    }

    private static String cleanName(String sectionName) {
        String name = StringUtils.trimToNull((String)sectionName);
        if (name == null) {
            log.trace("Specified name was null or empty.  Defaulting to the default section (name = \"\")");
            name = DEFAULT_SECTION_NAME;
        }
        return name;
    }

    public void setSectionProperty(String sectionName, String propertyName, String propertyValue) {
        String name = Configuration.cleanName(sectionName);
        Section section = this.getSection(name);
        if (section == null) {
            section = this.addSection(name);
        }
        section.put(propertyName, propertyValue);
    }

    public String getSectionProperty(String sectionName, String propertyName) {
        Section section = this.getSection(sectionName);
        return section != null ? section.get(propertyName) : null;
    }

    public String getSectionProperty(String sectionName, String propertyName, String defaultValue) {
        String value = this.getSectionProperty(sectionName, propertyName);
        return value != null ? value : defaultValue;
    }

    public static Configuration fromResourcePath(String resourcePath) throws ConfigurationException {
        if (!StringUtils.isNotEmpty((String)resourcePath)) {
            throw new IllegalArgumentException("Resource Path argument cannot be null or empty.");
        }
        Configuration config = new Configuration();
        config.loadFromPath(resourcePath);
        return config;
    }

    public void loadFromPath(String resourcePath) throws ConfigurationException {
        InputStream is;
        try {
            is = ResourceUtils.getInputStreamForPath(resourcePath);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        this.load(is);
    }

    public void load(String iniConfig) throws ConfigurationException {
        this.load(new Scanner(iniConfig));
    }

    public void load(InputStream is) throws ConfigurationException {
        InputStreamReader isr;
        if (is == null) {
            throw new NullPointerException("InputStream argument cannot be null.");
        }
        try {
            isr = new InputStreamReader(is, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException(e);
        }
        this.load(isr);
    }

    public void load(Reader reader) {
        Scanner scanner = new Scanner(reader);
        try {
            this.load(scanner);
        }
        finally {
            try {
                scanner.close();
            }
            catch (Exception e) {
                log.debug("Unable to cleanly close the InputStream scanner.  Non-critical - ignoring.", (Throwable)e);
            }
        }
    }

    private void addSection(String name, StringBuilder content) {
        Section section;
        String contentString;
        String cleaned;
        if (content.length() > 0 && (cleaned = StringUtils.clean((String)(contentString = content.toString()))) != null && !(section = new Section(name, contentString)).isEmpty()) {
            this.sections.put(name, section);
        }
    }

    public void load(Scanner scanner) {
        String sectionName = DEFAULT_SECTION_NAME;
        StringBuilder sectionContent = new StringBuilder();
        while (scanner.hasNextLine()) {
            String rawLine = scanner.nextLine();
            String line = StringUtils.clean((String)rawLine);
            if (line == null || line.startsWith(COMMENT_POUND) || line.startsWith(COMMENT_SEMICOLON)) continue;
            String newSectionName = Configuration.getSectionName(line);
            if (newSectionName != null) {
                this.addSection(sectionName, sectionContent);
                sectionContent = new StringBuilder();
                sectionName = newSectionName;
                if (!log.isDebugEnabled()) continue;
                log.debug("Parsing [" + sectionName + SECTION_SUFFIX);
                continue;
            }
            sectionContent.append(rawLine).append("\n");
        }
        this.addSection(sectionName, sectionContent);
        this.resolvePlaceHolder();
    }

    protected void resolvePlaceHolder() {
        Section sec;
        if (CollectionUtils.isEmpty(this.sections)) {
            return;
        }
        HashMap<String, String> propsMap = new HashMap<String, String>();
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            sec = entry.getValue();
            if (sec == null) continue;
            for (Map.Entry<String, String> sectionEntry : sec.entrySet()) {
                String key = sectionEntry.getKey();
                String value = sectionEntry.getValue();
                propsMap.put(key, value);
            }
        }
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            sec = entry.getValue();
            if (sec == null) continue;
            for (Map.Entry<String, String> sectionEntry : sec.entrySet()) {
                String value = sectionEntry.getValue();
                if (value != null) {
                    value = Configuration.resolvePlaceHolder(value, propsMap);
                }
                sectionEntry.setValue(value);
            }
        }
    }

    protected static String resolvePlaceHolder(String line, Map<String, String> propsMap) {
        boolean formateStart = false;
        boolean isEscape = false;
        boolean hasDoll = false;
        StringBuilder sb = new StringBuilder(20);
        sb.append("${");
        HashMap<String, String> replaceTemp = new HashMap<String, String>();
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char u = cArray[n2];
            if (u == '\\') {
                isEscape = true;
            } else if (u == '$' && !isEscape) {
                hasDoll = true;
            } else if (u == '}' && formateStart) {
                formateStart = false;
                sb.append("}");
                String paramName = sb.toString();
                String replaceName = propsMap.get(paramName.substring(2, paramName.length() - 1));
                if (replaceName != null) {
                    replaceName = Configuration.resolvePlaceHolder(replaceName, propsMap);
                    replaceTemp.put(paramName, replaceName);
                }
                sb = new StringBuilder(20);
                sb.append("${");
            } else if (u == '{' && hasDoll) {
                formateStart = true;
                hasDoll = false;
            } else if (formateStart) {
                sb.append(u);
            }
            if (u != '\\') {
                isEscape = false;
            }
            ++n2;
        }
        String result = line = line.replace("\\$", "%#%");
        if (!CollectionUtils.isEmpty(replaceTemp)) {
            for (Map.Entry entry : replaceTemp.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                result = result.replace(key, value);
            }
        }
        result = result.replace("%#%", "$");
        return result;
    }

    protected static boolean isSectionHeader(String line) {
        String s = StringUtils.trimToNull((String)line);
        return s != null && s.startsWith(SECTION_PREFIX) && s.endsWith(SECTION_SUFFIX);
    }

    protected static String getSectionName(String line) {
        String s = StringUtils.trimToNull((String)line);
        if (Configuration.isSectionHeader(s)) {
            return Configuration.cleanName(s.substring(1, s.length() - 1));
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Configuration) {
            Configuration ini = (Configuration)obj;
            return this.sections.equals(ini.sections);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.sections.hashCode();
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.sections)) {
            return "<empty INI>";
        }
        StringBuilder sb = new StringBuilder("sections=");
        int i = 0;
        for (Section section : this.sections.values()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(section.toString());
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.sections.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sections.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sections.containsValue(value);
    }

    @Override
    public Section get(Object key) {
        return this.sections.get(key);
    }

    @Override
    public Section put(String key, Section value) {
        return this.sections.put(key, value);
    }

    @Override
    public Section remove(Object key) {
        return this.sections.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Section> m) {
        this.sections.putAll(m);
    }

    @Override
    public void clear() {
        this.sections.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.sections.keySet());
    }

    @Override
    public Collection<Section> values() {
        return Collections.unmodifiableCollection(this.sections.values());
    }

    @Override
    public Set<Map.Entry<String, Section>> entrySet() {
        return Collections.unmodifiableSet(this.sections.entrySet());
    }
}

