/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.cm;

import com.ivms6.core.util.StringUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Section
implements Map<String, String> {
    private static Logger log = LoggerFactory.getLogger(Section.class);
    protected static final char ESCAPE_TOKEN = '\\';
    public static final String DEFAULT_SECTION_NAME = "";
    private final String name;
    private final Map<String, String> props;

    public Section(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        this.props = new LinkedHashMap<String, String>();
    }

    public Section(String name, String sectionContent) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        Map<String, String> props = !StringUtils.isBlank((String)sectionContent) ? Section.toMapProps(sectionContent) : new LinkedHashMap<String, String>();
        this.props = props != null ? props : new LinkedHashMap<String, String>();
    }

    public Section(Section defaults) {
        this(defaults.getName());
        this.putAll((Map<? extends String, ? extends String>)defaults.props);
    }

    protected static boolean isContinued(String line) {
        if (StringUtils.isBlank((String)line)) {
            return false;
        }
        int length = line.length();
        int backslashCount = 0;
        int i = length - 1;
        while (i > 0) {
            if (line.charAt(i) != '\\') break;
            ++backslashCount;
            --i;
        }
        return backslashCount % 2 != 0;
    }

    private static boolean isKeyValueSeparatorChar(char c) {
        return Character.isWhitespace(c) || c == ':' || c == '=';
    }

    private static boolean isCharEscaped(CharSequence s, int index) {
        return index > 0 && s.charAt(index - 1) == '\\';
    }

    protected static String[] splitKeyValue(String keyValueLine) {
        String line = StringUtils.trimToNull((String)keyValueLine);
        if (line == null) {
            return null;
        }
        StringBuilder keyBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        boolean buildingKey = true;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (buildingKey) {
                if (Section.isKeyValueSeparatorChar(c) && !Section.isCharEscaped(line, i)) {
                    buildingKey = false;
                } else {
                    keyBuffer.append(c);
                }
            } else if (valueBuffer.length() != 0 || !Section.isKeyValueSeparatorChar(c) || Section.isCharEscaped(line, i)) {
                valueBuffer.append(c);
            }
            ++i;
        }
        String key = StringUtils.trimToNull((String)keyBuffer.toString());
        String value = StringUtils.trimToEmpty((String)valueBuffer.toString());
        if (key == null || value == null) {
            String msg = "Line argument must contain a key and a value.  Only one string token was found.";
            throw new IllegalArgumentException(msg);
        }
        log.trace("Discovered key/value pair: {}={}", (Object)key, (Object)value);
        return new String[]{key, value};
    }

    private static Map<String, String> toMapProps(String content) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        StringBuilder lineBuffer = new StringBuilder();
        Scanner scanner = new Scanner(content);
        while (scanner.hasNextLine()) {
            String line = StringUtils.trimToNull((String)scanner.nextLine());
            if (line == null) continue;
            if (Section.isContinued(line)) {
                line = line.substring(0, line.length() - 1);
                lineBuffer.append(line);
                continue;
            }
            lineBuffer.append(line);
            line = lineBuffer.toString();
            lineBuffer = new StringBuilder();
            String[] kvPair = Section.splitKeyValue(line);
            props.put(kvPair[0], kvPair[1]);
        }
        return props;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        this.props.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.props.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.props.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.props.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.props.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.props.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this.props.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.props.putAll(m);
    }

    @Override
    public String remove(Object key) {
        return this.props.remove(key);
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public Collection<String> values() {
        return this.props.values();
    }

    public String toString() {
        String name = this.getName();
        if (DEFAULT_SECTION_NAME.equals(name)) {
            return "<default>";
        }
        return name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Section) {
            Section other = (Section)obj;
            return this.getName().equals(other.getName()) && this.props.equals(other.props);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() * 31 + this.props.hashCode();
    }
}

