/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.cm.modify;

import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.modify.PropertyItem;
import com.ivms6.core.util.cm.modify.SafeProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesOperator {
    protected static final Logger log = LoggerFactory.getLogger(PropertiesOperator.class);

    public void updateProperty(File file, String sectionName, String key, Object value) {
        if (file == null) {
            log.warn("file is null!");
            return;
        }
        SafeProperties sp = new SafeProperties(false);
        FileInputStream is = null;
        OutputStream os = null;
        String name = "";
        key = String.valueOf(sectionName) + "#-%" + key;
        try {
            try {
                is = new FileInputStream(file);
                sp.load(is);
                Enumeration<?> allValues = sp.propertyNames();
                if (allValues != null) {
                    while (allValues.hasMoreElements()) {
                        name = (String)allValues.nextElement();
                        if (!name.equals(key)) continue;
                        sp.put(name, value);
                        log.info("update [{}] {}={}", new Object[]{sectionName, key, value});
                    }
                }
                os = new FileOutputStream(file);
                sp.store(os, null);
            }
            catch (FileNotFoundException e) {
                log.error("file" + file.getName() + " not exist");
                try {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e2) {
                        log.error("close inputstream error", (Throwable)e2);
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e3) {
                            log.error("close outputstream error", (Throwable)e3);
                        }
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e4) {
                        log.error("close outputstream error", (Throwable)e4);
                    }
                }
            }
            catch (IOException e) {
                log.error("read or write file error", (Throwable)e);
                try {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e5) {
                        log.error("close inputstream error", (Throwable)e5);
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e6) {
                            log.error("close outputstream error", (Throwable)e6);
                        }
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e7) {
                        log.error("close outputstream error", (Throwable)e7);
                    }
                }
            }
        }
        finally {
            block64: {
                try {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e) {
                        log.error("close inputstream error", (Throwable)e);
                        try {
                            if (os != null) {
                                os.close();
                            }
                            break block64;
                        }
                        catch (IOException e8) {
                            log.error("close outputstream error", (Throwable)e8);
                        }
                        break block64;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        log.error("close outputstream error", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    log.error("close outputstream error", (Throwable)e);
                }
            }
        }
    }

    public void updateProperty(File file, PropertyItem item) {
        if (item == null) {
            return;
        }
        this.updateProperty(file, item.getSection(), item.getKey(), item.getValue());
    }

    public void updateProperty(File file, Collection<PropertyItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            log.info("update items is empty.");
            return;
        }
        if (items == null) {
            return;
        }
        if (file == null) {
            log.warn("file is null!");
            return;
        }
        SafeProperties sp = new SafeProperties(false);
        FileInputStream is = null;
        OutputStream os = null;
        try {
            try {
                String name = "";
                is = new FileInputStream(file);
                sp.load(is);
                for (PropertyItem item : items) {
                    String sectionName = item.getSection();
                    if (StringUtils.isEmpty((String)sectionName)) {
                        log.info("section name is empty.");
                        continue;
                    }
                    String key = item.getKey();
                    String value = item.getValue();
                    key = String.valueOf(sectionName) + "#-%" + key;
                    Enumeration<?> allValues = sp.propertyNames();
                    if (allValues == null) continue;
                    while (allValues.hasMoreElements()) {
                        name = (String)allValues.nextElement();
                        if (!name.equals(key)) continue;
                        sp.put(name, value);
                        log.info("ready to update [{}] {}={}", new Object[]{sectionName, key, value});
                    }
                }
                os = new FileOutputStream(file);
                sp.store(os, null);
            }
            catch (FileNotFoundException e) {
                log.error("file" + file.getName() + " not exist");
                try {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e2) {
                        log.error("close inputstream error", (Throwable)e2);
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e3) {
                            log.error("close outputstream error", (Throwable)e3);
                        }
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e4) {
                        log.error("close outputstream error", (Throwable)e4);
                    }
                }
            }
            catch (IOException e) {
                log.error("read or write file error", (Throwable)e);
                try {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e5) {
                        log.error("close inputstream error", (Throwable)e5);
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e6) {
                            log.error("close outputstream error", (Throwable)e6);
                        }
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e7) {
                        log.error("close outputstream error", (Throwable)e7);
                    }
                }
            }
        }
        finally {
            block67: {
                try {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e) {
                        log.error("close inputstream error", (Throwable)e);
                        try {
                            if (os != null) {
                                os.close();
                            }
                            break block67;
                        }
                        catch (IOException e8) {
                            log.error("close outputstream error", (Throwable)e8);
                        }
                        break block67;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        log.error("close outputstream error", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    log.error("close outputstream error", (Throwable)e);
                }
            }
        }
    }
}

