/*
 * Decompiled with CFR 0.152.
 */
package com.ivms6.core.util.coder;

import com.ivms6.core.util.ArrayUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.coder.Base64Utils;
import com.ivms6.core.util.exception.AESErrorException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    private static byte END_START = (byte)59;
    private static Cipher cipher = null;

    private static Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        cipher = Cipher.getInstance("AES/CFB/NoPadding");
        return cipher;
    }

    public static String encryptWithBase64(String sSrc, String sKey, String ivParameter) throws AESErrorException {
        AESUtils.ensureSrcNotNull(sSrc);
        AESUtils.ensureKeyIsRight(sKey);
        try {
            byte[] raw = sKey.getBytes("UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = AESUtils.getCipher();
            IvParameterSpec iv = new IvParameterSpec(ivParameter.getBytes(Charset.forName("UTF-8")));
            cipher.init(1, (Key)skeySpec, iv);
            byte[] encrypted = cipher.doFinal(sSrc.getBytes("utf-8"));
            return Base64Utils.encodeBase64String(encrypted, false);
        }
        catch (Exception e) {
            throw new AESErrorException(e);
        }
    }

    public static String decryptWithBase64(String sSrc, String sKey, String ivParameter) throws AESErrorException {
        AESUtils.ensureSrcNotNull(sSrc);
        AESUtils.ensureKeyIsRight(sKey);
        try {
            byte[] raw = sKey.getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = AESUtils.getCipher();
            IvParameterSpec iv = new IvParameterSpec(ivParameter.getBytes(Charset.forName("UTF-8")));
            cipher.init(2, (Key)skeySpec, iv);
            byte[] encrypted = Base64Utils.decodeBase64((String)sSrc);
            byte[] original = cipher.doFinal(encrypted);
            return new String(original, "utf-8");
        }
        catch (Exception ex) {
            throw new AESErrorException(ex);
        }
    }

    private static byte[] removeEndFlag(byte[] original) {
        int length;
        int index = ArrayUtils.lastIndexOf((byte[])original, (byte)END_START);
        if (index >= (length = original.length) - 1) {
            return original;
        }
        if (original[index + 1] == 0) {
            return ArrayUtils.subarray((byte[])original, (int)0, (int)index);
        }
        return original;
    }

    private static byte[] buildFullSrc(String sSrc) throws UnsupportedEncodingException {
        byte[] src = sSrc.getBytes("utf-8");
        int len = src.length;
        if (len % 16 == 0) {
            return src;
        }
        int append = 16 - len % 16;
        byte[] appendArr = new byte[append];
        appendArr[0] = END_START;
        int i = 1;
        while (i < append) {
            appendArr[i] = 0;
            ++i;
        }
        return ArrayUtils.addAll((byte[])src, (byte[])appendArr);
    }

    private static void ensureSrcNotNull(String sSrc) {
        if (StringUtils.isEmpty((String)sSrc)) {
            throw new IllegalArgumentException("src is empty.");
        }
    }

    private static void ensureKeyIsRight(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is empty.");
        }
        if (key.length() != 16) {
            throw new IllegalArgumentException("Key\u957f\u5ea6\u4e0d\u662f16\u4f4d");
        }
    }

    @Deprecated
    public static String decrypt(String sSrc, String sKey) throws AESErrorException {
        AESUtils.ensureKeyIsRight(sKey);
        try {
            byte[] raw = sKey.getBytes("ASCII");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = AESUtils.getCipher();
            cipher.init(2, skeySpec);
            byte[] encrypted1 = AESUtils.hex2byte(sSrc);
            byte[] original = cipher.doFinal(encrypted1);
            String originalString = new String(original, Charset.forName("utf-8"));
            return originalString;
        }
        catch (Exception ex) {
            throw new AESErrorException(ex);
        }
    }

    @Deprecated
    public static String encrypt(String sSrc, String sKey) throws AESErrorException {
        AESUtils.ensureKeyIsRight(sKey);
        try {
            byte[] raw = sKey.getBytes("ASCII");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = AESUtils.getCipher();
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(sSrc.getBytes(Charset.forName("utf-8")));
            return AESUtils.byte2hex(encrypted).toLowerCase();
        }
        catch (Exception e) {
            throw new AESErrorException(e);
        }
    }

    private static byte[] hex2byte(String strhex) {
        if (strhex == null) {
            return null;
        }
        int l = strhex.length();
        if (l < 0 || l % 2 == 1) {
            return null;
        }
        byte[] b = new byte[l / 2];
        int i = 0;
        while (i != l / 2) {
            b[i] = (byte)Integer.parseInt(strhex.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return b;
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
            } else {
                hs.append(stmp);
            }
            ++n;
        }
        return hs.toString().toUpperCase();
    }

    public static void main(String[] args) throws AESErrorException, NoSuchAlgorithmException {
        String password = "Abc123";
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(password.getBytes());
        String pwd = new String(md.digest());
        System.err.println(pwd);
    }
}

